Un webservice qui traite les webhooks Sentry pour créer/lier des tickets sur Redmine.

## Fonctionnalités

- Créer un ticket redmine
- Lier un ticket redmine existant via son identifiant

## Environnement de développement

```bash
pip install flask python-redmine

# Variables d'environnement nécessaires
export REDMINE_URL=https://dev.entrouvert.org/
export REDMINE_API_KEY=xxx
export REDMINE_DEFAULT_PROJECT=suivi-des-traces
export SENTRY_URL=https://sentry-test.entrouvert.org/
export SENTRY_TOKEN=XXX
export SENTRY_CLIENT_SECRET=abcd
export SENTRY_ORGANIZATION_ID=1
export LOG_LEVEL=DEBUG

# lancer le serveur en développement
flask --app sentry_redmine --debug run
```

## Configuration Redmine

Côté Redmine, créer un utilisateur sentry dédié et lui donner les droits administrateurs pour pouvoir faire le mapping entre les utilisateurs sentry et les utilisateurs redmine.

Récupérer la clé d'API de l'utilisateur qui servira pour le déploiement.

## Configuration Sentry

Côté Sentry, configurer [une intégration interne au niveau de l'organisation](https://sentry-test.entrouvert.org/settings/entrouvert/developer-settings/?type=internal)

* Name: Redmine
* Webhook URL: https://dev.entrouvert.org/sentry/
* Schema:
```
{
  "elements": [
    {
      "type": "issue-link",
      "create": {
        "uri": "/sentry/api/issue/create/",
        "required_fields": [
          {
            "type": "text",
            "label": "Titre",
            "name": "title",
            "default": "issue.title"
          },
          {
            "type": "textarea",
            "label": "Description",
            "name": "description",
            "default": "issue.description"
          },
          {
            "type": "select",
            "label": "Projet",
            "name": "project",
            "uri": "/sentry/api/items/project/",
            "async": true
          }
        ]
      },
      "link": {
        "uri": "/sentry/api/issue/link/",
        "required_fields": [
          {
            "type": "select",
            "label": "Numéro de ticket",
            "name": "issue_id",
            "uri": "/sentry/api/items/issue/",
            "async": true
          }
        ]
      }
    }
  ]
}
```
* Overview: Créer un ticket redmine
* Avatar: https://www.redmine.org/attachments/3462/redmine_fluid_icon.png
* Permissions:
  * Team: read
  * Organization: read
  * Member: read

Générer un jeton et le copier dans la configuration de systemd, ainsi que le secret client.

## Déploiement

Copier `debian/sentry-redmine.service` dans `/etc/systemd/system/`.

Configuer les clés et le niveau de log dans `/etc/systemd/system/sentry-redmine.service.d/10-environment.conf` ainsi:

```
[Service]
Environment=REDMINE_API_KEY=XXX
Environment=SENTRY_TOKEN=YYY
Environment=SENTRY_CLIENT_SECRET=ZZZ
Environment=LOG_LEVEL=DEBUG
```

Configurer le vhost dev.entrouvert.org dans la configuration d'Apache `/etc/apache2/sites-enabled/dev.entrouvert.org.conf`:
```
<VirtualHost *:80>
    ServerName dev.entrouvert.org
...
    <Location "/sentry/">
        ProxyPass unix:/run/sentry-redmine/gitea-redmine.sock|http://localhost/
        PassengerEnabled off
        Require all granted
    </Location>
```

## Tests

Lancer classiquement via `tox`.
