# Generated by Django 3.2.18 on 2024-06-27 08:14

import django.db.models.deletion
from django.db import migrations, models


def delete_issuer_is_null(apps, schema_editor):
    # prevent error " ne peut pas exécuter ALTER TABLE «
    # mellon_usersamlidentifier » car il reste des événements sur les triggers"
    # during later schema alteration
    schema_editor.execute('SET CONSTRAINTS ALL IMMEDIATE')
    UserSAMLIdentifier = apps.get_model('mellon', 'UserSAMLIdentifier')
    UserSAMLIdentifier.objects.filter(issuer__isnull=True).delete()


class Migration(migrations.Migration):
    dependencies = [
        ('mellon', '0009_set_on_delete_protect_on_issuer'),
    ]

    operations = [
        migrations.RunPython(delete_issuer_is_null, migrations.RunPython.noop),
        migrations.AlterField(
            model_name='usersamlidentifier',
            name='issuer',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to='mellon.issuer', verbose_name='Issuer'
            ),
        ),
    ]
