from authentic2.models import Attribute
from django.contrib.auth import get_user_model
from django.urls import reverse
from utils import login

from authentic2_cut.apps import AppConfig


def test_a2_hook_front_modify_form(db, rf, app, admin, settings):
    class DummyModule:
        __path__ = [
            './dummy',
        ]

    dummy = DummyModule()
    title = Attribute.objects.get(name='title')
    app_config = AppConfig('authentic2_cut', dummy)

    User = get_user_model()
    user = User.objects.create(
        email='john.doe@example.org', first_name='John', last_name='Doe', username='jdoe'
    )
    user.set_password('jdoe')
    user.save()

    login(app, user)
    response = app.get(reverse('cut-edit-core'))
    assert response.form.fields['first_name'][0].attrs['autocomplete'] == 'given-name'
    assert response.form.fields['last_name'][0].attrs['autocomplete'] == 'family-name'
    assert response.form.fields['address_country'][0].attrs['autocomplete'] == 'country-name'
    assert response.form.fields['address_zipcode'][0].attrs['autocomplete'] == 'postal-code'
    assert response.form.fields['home_mobile_phone_1'][0].attrs['autocomplete'] == 'tel-local'
