# authentic2_cut - Authentic2 plugin for CUT
# Copyright (C) 2017  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from authentic2.forms.profile import EditProfileForm
from django import forms

from . import models


class ValidationForm(forms.Form):
    reason = forms.ChoiceField(
        choices=(('', 'Aucune'),) + models.ValidationRequest.REASON_CHOICES,
        required=False,
        label='Raison du refus',
    )


class EditCoreForm(EditProfileForm):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        if 'address_country' in self.fields:
            self.fields['address_country'].widget.attrs['autocomplete'] = 'country-name'
        if 'address_zipcode' in self.fields:
            self.fields['address_zipcode'].widget.attrs['autocomplete'] = 'postal-code'
        if 'home_mobile_phone' in self.fields:
            self.fields['home_mobile_phone'].widget.widgets[1].attrs['autocomplete'] = 'tel-local'
