# authentic2_cut - Authentic2 plugin for CUT
# Copyright (C) 2017  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from django.conf.urls import url
from authentic2.manager.urls import manager_login_required

from . import views, api_views
from authentic2.decorators import required

urlpatterns = required(
    manager_login_required, [
        url('^accounts/edit-core/$', views.edit_core, name='cut-edit-core'),
        url('^accounts/edit-crown/$', views.edit_crown, name='cut-edit-crown'),
        url(r'^manage/users/(?P<pk>\d+)/$', views.manager_user_detail,
            name='a2-manager-user-detail'),
        url(r'^manage/users/uuid:(?P<slug>[a-z0-9]+)/$', views.manager_user_detail,
            name='a2-manager-user-by-uuid-detail'),
        url('^manage/users/(?P<pk>\d+)/edit-core/$', views.manager_user_edit_core,
            name='cut-manager-user-edit-core'),
        url('^manage/users/(?P<pk>\d+)/actions-journal/$', views.user_actions_journal,
            name='cut-manager-user-actions-journal'),
        url('^manage/users/(?P<pk>\d+)/modifications-journal/$', views.user_modifications_journal,
            name='cut-manager-user-modifications-journal'),
        url('^manage/validation/$', views.validation_homepage,
            name='cut-manager-user-validation'),
        url('^manage/validation/next/$', views.next_validation,
            name='cut-manager-user-next-validation'),
        url('^manage/validation/(?P<pk>\d+)/$', views.validation,
            name='cut-manager-user-validation'),
        url('^manage/validation/attachment/(?P<pk>\d*)/(?P<filename>.*)$', views.validation_attachment,
            name='cut-manager-user-validation-attachment'),
        url('^manage/validation/attachment-thumbnail/(?P<pk>\d*)/(?P<filename>.*)$', views.validation_attachment_thumbnail,
            name='cut-manager-user-validation-attachment-thumbnail'),
    ]
)

urlpatterns += [
    url('^cgu/$', views.cgu,
        name='cut-cgu'),
    url('^api/validate/$', api_views.validate, name='api-cut-validate'),
]
