# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Journal',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('timestamp', models.DateTimeField(auto_now_add=True, verbose_name='Horodatage', db_index=True)),
                ('message', models.TextField(verbose_name=b'Message')),
                ('actor', models.ForeignKey(related_name='actor_journal', verbose_name='Auteur', to=settings.AUTH_USER_MODEL)),
                ('subject', models.ForeignKey(related_name='subject_journal', verbose_name=b'Sujet', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-timestamp', '-id'),
                'verbose_name': 'historique',
                'verbose_name_plural': 'historiques',
            },
        ),
    ]
