# Generated by Django 2.2.26 on 2022-07-21 15:24

from django.db import migrations


def cleanup_saml_authenticator(apps, schema_editor):
    # In module authentic2_auth_saml we automatically created authenticators
    # from config in migration 0002_auto_20220608_1559, wrongly including Fedict IdP.

    SAMLAuthenticator = apps.get_model('authentic2_auth_saml', 'SAMLAuthenticator')
    SAMLAuthenticator.objects.filter(
        enabled=False,
        metadata_url__in=[
            'https://iamapps-public.belgium.be/saml/fas-metadata.xml',
            'https://iamapps-public.int.belgium.be/saml/fas-metadata.xml',
        ],
    ).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('authentic2_auth_fedict', '0002_auto_20220706_1712'),
        ('authentic2_auth_saml', '0002_auto_20220608_1559'),
    ]

    operations = [
        migrations.RunPython(cleanup_saml_authenticator, reverse_code=migrations.RunPython.noop),
    ]
