# Generated by Django 2.2.26 on 2022-07-06 15:12

from django.conf import settings
from django.db import migrations


def create_fedict_authenticator(apps, schema_editor):
    if not getattr(settings, 'A2_AUTH_FEDICT_ENABLE', False):
        return

    FedictAuthenticator = apps.get_model('authentic2_auth_fedict', 'FedictAuthenticator')

    kwargs_settings = getattr(settings, 'AUTH_FRONTENDS_KWARGS', {})
    authenticator_settings = kwargs_settings.get('fedict', {})

    priority = authenticator_settings.get('priority')
    priority = priority if priority is not None else -1

    FedictAuthenticator.objects.create(
        slug='fedict-authenticator',
        order=priority,
        show_condition=authenticator_settings.get('show_condition') or '',
        enabled=True,
    )


class Migration(migrations.Migration):

    dependencies = [
        ('authentic2_auth_fedict', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(create_fedict_authenticator, reverse_code=migrations.RunPython.noop),
    ]
