# authentic2_auth_fedict - Fedict authentication for Authentic
# Copyright (C) 2016  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from authentic2.authenticators import BaseAuthenticator
from django.shortcuts import render
from django.template.loader import render_to_string
from django.utils.translation import ugettext_lazy as _
from mellon.utils import get_idp, get_idps

try:
    from authentic2.utils import redirect_to_login
except ImportError:
    from authentic2.utils.misc import redirect_to_login

from . import app_settings


class FedictAuthenticator(BaseAuthenticator):
    id = 'fedict'
    priority = 1

    def enabled(self):
        return app_settings.enable and list(get_idps())

    def name(self):
        return _('Belgian eID')

    def login(self, request, *args, **kwargs):
        context = kwargs.get('context', {}).copy()
        submit_name = 'login-%s' % self.id
        if request.method == 'POST' and submit_name in request.POST:
            return redirect_to_login(request, login_url='fedict-login')
        context['submit_name'] = submit_name
        return render(request, 'authentic2_auth_fedict/login.html', context)

    def profile(self, request, *args, **kwargs):
        context = kwargs.get('context', {}).copy()
        user_saml_identifiers = request.user.saml_identifiers.all()
        for user_saml_identifier in user_saml_identifiers:
            user_saml_identifier.idp = get_idp(user_saml_identifier.issuer)
        context['user_saml_identifiers'] = user_saml_identifiers
        return render_to_string('authentic2_auth_fedict/profile.html', context, request=request)
