# Installation des composants

Publik est la somme de plusieurs composants qui communiquent entre eux
via messages et webservices. Chaque composant est un paquet Debian qui
s'installe depuis de dépôt Entr'ouvert.


## Installation PostgreSQL

Lors de leur installation les briques s’attendent à trouver un service
PostgreSQL fonctionnel, la configuration par défaut utilise un serveur
local, qui peut s’installer via :

    # apt install postgresql-server

Vérifier que le service tourne :

    # systemctl status postgresql@9.6-main.service
    ● postgresql@9.6-main.service - PostgreSQL Cluster 9.6-main
       Loaded: loaded (/lib/systemd/system/postgresql@.service; disabled; vendor preset: enabled)
       Active: active (running) since ...
     Main PID: 115468 (postgres)
       CGroup: /system.slice/system-postgresql.slice/postgresql@9.6-main.service
       [...]


## Installation RabbitMQ

RabbitMQ sera utilisé uniquement en local (127.0.0.1) et n'a besoin
d'aucune configuration particulière. Veiller cependant à vérifier son
bon fonctionnement avant de continuer l'installation. RabbitMQ est assez
sensible à la résolution DNS (présence de la machine locale dans
/etc/hosts, par exemple) :

    # apt install rabbitmq-server

Vérifier que le service tourne :

    # systemctl status rabbitmq-server
    ● rabbitmq-server.service - RabbitMQ broker
      Loaded: loaded (/lib/systemd/system/rabbitmq-server.service; enabled)
      Active: active (running) since lun. 2017-07-17 10:09:57 CEST; 4 days ago
    Main PID: 580 (beam.smp)
    Status: "Initialized"

     CGroup: /system.slice/rabbitmq-server.service
     ├─ 580 /usr/lib/erlang/erts-6.2/bin/beam.smp [...]
     ├─ 897 /usr/lib/erlang/erts-6.2/bin/epmd -daemon
     ├─1780 inet_gethost 4
     └─1781 inet_gethost 4

Et absence d'erreur dans les logs, qui doivent ressembler à :

    # journalctl -u rabbitmq-server.service

    -- Logs begin at lun. 2017-07-17 10:09:46 CEST, end at ven. 2017-07-21 19:55:37 CEST. --

    juil. 17 10:09:50 web1-preprod systemd[1]: Starting RabbitMQ broker...
    juil. 17 10:09:54 web1-preprod rabbitmq-server[580]: RabbitMQ 3.6.10.  Copyright (C) 2007-2017 Pivotal Software, Inc.
    juil. 17 10:09:54 web1-preprod rabbitmq-server[580]: ## ## Licensed under the MPL. See http://www.rabbitmq.com/
    juil. 17 10:09:54 web1-preprod rabbitmq-server[580]: ## ##
    juil. 17 10:09:54 web1-preprod rabbitmq-server[580]: ########## Logs: /var/log/rabbitmq/rabbit@web1-preprod.log
    juil. 17 10:09:54 web1-preprod rabbitmq-server[580]: ###### ## /var/log/rabbitmq/rabbit@web1-preprod-sasl.log
    juil. 17 10:09:54 web1-preprod rabbitmq-server[580]: ##########
    juil. 17 10:09:54 web1-preprod rabbitmq-server[580]: Starting broker...
    juil. 17 10:09:57 web1-preprod rabbitmq-server[580]: systemd unit for activation check: "rabbitmq-server.service"
    juil. 17 10:09:57 web1-preprod systemd[1]: Started RabbitMQ broker.  
    juil. 17 10:09:57 web1-preprod rabbitmq-server[580]: completed with 0 plugins.


## Installation Combo

Dans */etc/combo/settings.d/database.py* nous renseignons les paramètres de connexion particuliers, par exemple le mot-de-passe ajouté à l'étape de création manuelle des bases :

    DATABASES['default']['PASSWORD'] = "foobar"

Dans */etc/combo/settings.d/macollectivite.py*,
nous configurons l'envoi des traces d'erreur par l'ajout de ces lignes
en fin de fichier :

    ADMINS = (('Admin EO', 'admin+prod.macollectivite.combo@entrouvert.com'),)
    EMAIL_SUBJECT_PREFIX = '[prod macollectivite combo] '
    SERVER_EMAIL = 'admin+prod.macollectivite.passerelle@entrouvert.com'

On installe ensuite le logiciel *combo* :

    # apt install combo

Vérification avec *systemctl status combo* :

    # systemctl status combo
    ● combo.service - Combo
       Loaded: loaded (/lib/systemd/system/combo.service; enabled)
       Active: active (running) since jeu. 2019-07-20 13:33:44 CEST; 19h ago
      Process: 16317 ExecStartPre=/usr/bin/combo-manage collectstatic --noinput (code=exited, status=0/SUCCESS)
      Process: 16319 ExecStartPre=/usr/bin/combo-manage migrate_schemas --noinput (code=exited, status=0/SUCCESS)
     Main PID: 16324 (uwsgi)
       Status: "uWSGI is ready"
       CGroup: /system.slice/combo.service
               ├─16429 combo uWSGI worker 1
               ├─16434 combo uWSGI worker 5
               ├─16436 combo uWSGI worker 3
               ├─16483 combo uWSGI worker 2
               ├─16421 combo uWSGI worker 4
               └─16324 combo uWSGI master

## Installation Passerelle

La procédure est la même que pour Combo

Dans */etc/combo/settings.d/database.py* nous renseignons les paramètres de connexion particuliers.

Dans */etc/passerelle/settings.d/macollectivite.py*,
configuration pour l'envoi des traces d'erreur par l'ajout de ces lignes
en fin de fichier :

    ADMINS = (('Admin EO', 'admin+prod.macollectivite.passerelle@entrouvert.com'),)
    EMAIL_SUBJECT_PREFIX = '[prod macollectivite passerelle] '
    SERVER_EMAIL = 'admin+prod.macollectivite.passerelle@entrouvert.com'

Nous pouvons ensuite installer le composant :

    # apt install passerelle

Et vérification avec *systemctl is-active passerelle* qui doit montrer
«active»

## Installation Fargo

Reprendre la même procédure que pour les autres composants, en adaptant
le nom de la brique, c'est-à-dire :

1.  Configuration du mail dans */etc/fargo/settings.d/macollectivite.py*
2.  Installation du composant :

        # apt install fargo

3.  Vérification avec *systemctl is-active fargo* qui doit retourner « active »

## Installation Hobo serveur

Reprendre la même procédure que pour les autres composants, en adaptant
le nom de la brique, c'est-à-dire :

1.  Configuration du mail dans */etc/hobo/settings.d/macollectivite.py*
2.  Installation du composant :

        # apt install hobo

3.  Vérification avec *systemctl is-active hobo* qui doit retourner « active »

## Installation Hobo agent

Il s'agit d'un composant qui va écouter les ordres de déploiement (ou
provisionning) envoyés par le serveur Hobo et les exécuter sur les
autres composants.

Installation :

    # apt install hobo-agent

Ce démon est piloté par supervisor, ce dernier a parfois du mal à se
lancer dès la première installation. On remet donc tout à plat avec :

    systemctl stop supervisor
    systemctl start supervisor

Et on vérifie que hobo-agent est bien lancé par supervisor :

    # systemctl status supervisor
    ● supervisor.service - LSB: Start/stop supervisor
     Loaded: loaded (/etc/init.d/supervisor)
     Active: active (running) since lun. 2017-07-17 10:09:52 CEST; 4 days ago
     CGroup: /system.slice/supervisor.service
     ├─1065 /usr/bin/python /usr/bin/supervisord -c /etc/supervisor/supervisord.conf
     ├─1208 python2.7 /usr/bin/celery worker --hostname=agent.%h --app=hobo.agent.worker --loglevel=INFO --concurrency=1
     └─1494 python2.7 /usr/bin/celery worker --hostname=agent.%h --app=hobo.agent.worker --loglevel=INFO --concurrency=1

## Installation Authentic

Le système Authentic, un peu plus ancien que les autres composants, ne
suit pas exactement les mêmes principes et les mêmes nommages.

Le nom du paquet à installer est *authentic2-multitenant* :

    # apt install authentic2-multitenant

Dans */etc/authentic2-multitenant/settings.d/macollectivite.py*, la
configuration mail :

    ADMINS = (('Admin EO', 'admin+prod.macollectivite.authentic@entrouvert.com'),)
    EMAIL_SUBJECT_PREFIX = '[prod macollectivite authentic] '
    SERVER_EMAIL = 'admin+prod.macollectivite.authentic@entrouvert.com'

Vérification avec *service authentic2-multitenant status* :

    # systemctl status authentic2-multitenant
    ● authentic2-multitenant.service - LSB: Authentic2 is a versatile identity provider
     Loaded: loaded (/etc/init.d/authentic2-multitenant)
     Active: active (running) since jeu. 2017-07-20 18:48:47 CEST; 24h ago
     CGroup: /system.slice/authentic2-multitenant.service
     ├─21361 /usr/bin/python /usr/bin/gunicorn --pid /var/run/authentic2-multitenant/authentic2-multitenant.pid --user authentic-multitenant --group authentic-m...
     ├─21372 /usr/bin/python /usr/bin/gunicorn --pid /var/run/authentic2-multitenant/authentic2-multitenant.pid --user authentic-multitenant --group authentic-m...
     ├─21377 /usr/bin/python /usr/bin/gunicorn --pid /var/run/authentic2-multitenant/authentic2-multitenant.pid --user authentic-multitenant --group authentic-m...
     ├─21380 /usr/bin/python /usr/bin/gunicorn --pid /var/run/authentic2-multitenant/authentic2-multitenant.pid --user authentic-multitenant --group authentic-m...
     └─25604 /usr/bin/python /usr/bin/gunicorn --pid /var/run/authentic2-multitenant/authentic2-multitenant.pid --user authentic-multitenant --group authentic-m...

## Installation w.c.s.

Comme noté précédemment le module w.c.s. est spécifique et n'a pas besoin de
configuration initiale pour configurer ses mails, il y a donc
simplement deux étapes :

1.  Installation du composant :

        # apt install wcs wcs-au-quotidien

2.  Vérification avec *systemctl is-active wcs* qui doit retourner « active »



## Installation de Nginx

    # apt install nginx

... rien de plus. Nous installons la version de Debian 10.

## Configuration de base

Mise en place d'un format de log avancé (qui affiche le tenant) dans
*/etc/nginx/conf.d/log_formats.conf* :

    # /etc/nginx/conf.d/log_formats.conf

    log_format combined_full '$remote_addr - $remote_user [$time_local] "$request" ' '$status $body_bytes_sent "$http_referer" ' '"$http_user_agent" "$host" [$request_time ms]';

    log_format with_request_time '$remote_addr - $remote_user [$time_local] [$request_time ms] ' '"$request" $status $body_bytes_sent ' '"$http_referer" "$http_user_agent"';

Pour contrôler la taille maximale des fichiers téléversables [#18476](https://dev.entrouvert.org/issues/18476),
ajouter ce fichier : */etc/nginx/conf.d/client-max-body-size.conf* avec
ce contenu :

    client_max_body_size 200M;

Il faut éventuellement adapter la configuration du HAProxy pour accepter
les grosses requêtes.

## Mise en place des virtualhost (frontaux HTTP des tenants des composants Publik)

Le soin est laissé à l'installateur de décider comment poser les
virtualhost ci-dessous dans nginx.

Au niveau de la preprod, le modèle classique a été adopté :

-   un fichier par virtualhost dans */etc/nginx/sites-available/*
-   des liens symboliques dans */etc/nginx/sites-enabled/* avec un
    préfixe *10_* permettant un éventuel classement d'autres services
    avant ou après.
-   la terminaison SSL est assurée en amont et le traffic parvient
    non-chiffré à nginx.

A noter que **ces fichiers **N**ginx de la **plate-forme de
**pré-prod**uction** peuvent être copiés** pour la plate-forme de
production, il faudra cependant veiller à la modification du
server_name du portail usagers dans le virtualhost "combo".

### Combo

    server {
        listen 80;
        server_name ~^moncompte.*; # portail usagers ; selon le nom du site
        # (attention, différent de la pré-prod)
        ~^agents-.*; # portail agents ; selon le nom du site

        access_log /var/log/nginx/combo-access.log combined_full;
        error_log /var/log/nginx/combo-error.log;

        location ~ ^/static/(.+)$ {
            root /;
            try_files /var/lib/combo/tenants/$host/static/$1
                      /var/lib/combo/tenants/$host/theme/static/$1
                      /var/lib/combo/collectstatic/$1
                      =404;
            add_header Access-Control-Allow-Origin *;
        }

        location ~ ^/media/(.+)$ {
           alias /var/lib/combo/tenants/$host/media/$1;
        }

        location / {
           proxy_pass http://unix:/run/combo/combo.sock;
           proxy_set_header Host $http_host;
           proxy_set_header X-Forwarded-SSL on;
           proxy_set_header X-Forwarded-Protocol ssl;
           proxy_set_header X-Forwarded-Proto https;
           proxy_set_header X-Real-IP $remote_addr;
           proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        }
    }

### Hobo

Même modèle que Combo :

    server {
        listen 80;

        server_name ~^hobo-.*;

        access_log /var/log/nginx/hobo-access.log combined_full;
        error_log /var/log/nginx/hobo-error.log;

        location ~ ^/static/(.+)$ {
            root /;
            try_files /var/lib/hobo/tenants/$host/static/$1
                      /var/lib/hobo/tenants/$host/theme/static/$1
                      /var/lib/hobo/collectstatic/$1
                      =404;
            add_header Access-Control-Allow-Origin *;
        }

        location ~ ^/media/(.+)$ {
            alias /var/lib/hobo/tenants/$host/media/$1;
        }

        location / {
            proxy_pass http://unix:/run/hobo/hobo.sock;
            proxy_set_header Host $http_host;
            proxy_set_header X-Forwarded-SSL on;
            proxy_set_header X-Forwarded-Protocol ssl;
            proxy_set_header X-Forwarded-Proto https;
            proxy_set_header X-Real-IP $remote_addr;
            proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        }

    }

### Passerelle

Même modèle que Combo, mais aucune diffusion de /media (il s'agit de
données privées dans Passerelle).

    server {
        listen 80;

        server_name ~^passerelle-.*;

        access_log /var/log/nginx/passerelle-access.log combined_full;
        error_log /var/log/nginx/passerelle-error.log;

        location ~ ^/static/(.+)$ {
            root /;
            try_files /var/lib/passerelle/tenants/$host/static/$1
                      /var/lib/passerelle/tenants/$host/theme/static/$1
                      /var/lib/passerelle/collectstatic/$1
                      =404;
            add_header Access-Control-Allow-Origin *;
        }

        location / {
            proxy_pass http://unix:/run/passerelle/passerelle.sock;
            proxy_set_header Host $http_host;
            proxy_set_header X-Forwarded-SSL on;
            proxy_set_header X-Forwarded-Protocol ssl;
            proxy_set_header X-Forwarded-Proto https;
            proxy_set_header X-Real-IP $remote_addr;
            proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        }
    }

### Fargo

Même modèle que Combo, mais aucune diffusion de /media (il s'agit des
fichiers usagers privés dans Fargo).

    server {
        listen 80;

        server_name ~^portedoc-.*;

        access_log /var/log/nginx/fargo-access.log combined_full;
        error_log /var/log/nginx/fargo-error.log;

        location ~ ^/static/(.+)$ {
            root /;
            try_files /var/lib/fargo/tenants/$host/static/$1
                      /var/lib/fargo/tenants/$host/theme/static/$1
                      /var/lib/fargo/collectstatic/$1
                      =404;
            add_header Access-Control-Allow-Origin *;
        }

        location / {
            proxy_pass http://unix:/run/fargo/fargo.sock;
            proxy_set_header Host $http_host;
            proxy_set_header X-Forwarded-SSL on;
            proxy_set_header X-Forwarded-Protocol ssl;
            proxy_set_header X-Forwarded-Proto https;
            proxy_set_header X-Real-IP $remote_addr;
            proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        }

    }

### Authentic

Comme Combo, sans diffusion des /media, et en utilisant le nom du
service *authentic2-multitenant.*

    server {
        listen 80;

        server_name ~^connexion-.*;

        access_log /var/log/nginx/authentic2-multitenant-access.log combined_full;
        error_log /var/log/nginx/authentic2-multitenant-error.log;

        location ~ ^/static/(.+)$ {
            root /;
            try_files /var/lib/authentic2-multitenant/tenants/$host/static/$1
                      /var/lib/authentic2-multitenant/tenants/$host/theme/static/$1
                      /var/lib/authentic2-multitenant/collectstatic/$1
                      =404;
            add_header Access-Control-Allow-Origin *;
        }

        location / {
            proxy_pass http://unix:/run/authentic2-multitenant/authentic2-multitenant.sock;
            proxy_set_header Host $http_host;
            proxy_set_header X-Forwarded-SSL on;
            proxy_set_header X-Forwarded-Protocol ssl;
            proxy_set_header X-Forwarded-Proto https;
            proxy_set_header X-Real-IP $remote_addr;
            proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        }
    }

### w.c.s.

    server {

        listen 80;

        server_name ~^demarches-.*;

        access_log /var/log/nginx/wcs-access.log combined_full;
        error_log /var/log/nginx/wcs-error.log;

        location ~ ^/static/(.+)$ {
            root /;
            try_files /var/lib/wcs/$host/static/$1
                      /var/lib/wcs/$host/theme/static/$1
                      /var/lib/wcs/collectstatic/$1
                      =404;
        }

        location /qo { alias /usr/share/wcs/qommon/; }
        location /apache-errors { alias /usr/share/auquotidien/apache-errors/; }

        location /themes {
            root /;
            try_files /var/lib/wcs/$host$uri
                      /usr/share/wcs/$uri
                      =404;
        }

        location / {
            proxy_pass http://unix:/var/run/wcs/wcs.sock;
            proxy_set_header Host $http_host;
            proxy_set_header X-Real-IP $remote_addr;
            proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
            proxy_set_header X-Forwarded-SSL on;
            proxy_set_header X-Forwarded-Protocol ssl;
            proxy_set_header X-Forwarded-Proto https;
        }
    }

## Vérification des réponses de Nginx

Une fois les virtualhost en place, les sites doivent répondre par des
erreurs 404 : ce sont les applications de Publik qui répondent qu'elles
n'ont pas encore d'instance liés aux noms prévus.

C'est tout de même déjà le temps de vérifier :

-   que les certificats HTTPS sont ok,
-   que haproxy envoie bien sur web1 (si vous l'avez déjà installé),
-   que les requêtes arrivent sur les bons virtualhost, par exemple pour
    fargo on vérifiera que l'accès à
    [https://portedoc-moncompte.macollectivite.fr](https://portedoc-moncompte.macollectivite.fr/)
    provoque une 404 dans */var/log/nginx/fargo-access.log* et aucun
    message dans */var/log/nginx/fargo-error.log* ; opération à répéter
    avec tous les autres sites installés.
