# Mises-à-jour des composants

## Fréquence des mises-à-jour

Entr'ouvert livre une nouvelle version de Publik les soirs des 2ème et
4ème jeudi de chaque mois. L'installation peut être faite aussitôt, mais
nous conseillons à des hébergeurs tiers non infogérés par Entr'ouvert de
faire la mise à jour le mardi suivant.

La mise à jour provoque une courte indisponibilité du système : elle
doit être faite sur des heures de faible affluence. Pour information,
Entr'ouvert effectue ces mises à jour autour de 22 ou 23h le jeudi soir,
en attendant une baisse de la fréquentation visible dans les logs nginx.

## Déroulé en installation double (load-balancing)

S'agissant d'une installation double (load-balancing entre web1 et
web2), la procédure générale à suivre est :

1.  arrêt du frontal nginx sur web2 ⇒ HAProxy envoie tout sur web1,
2.  vérifier que PostgreSQL est bien fonctionnel,
3.  mise à jour de web1 (procédure ci-dessous),
4.  vérification du fonctionnement du site (parcours de 3 ou 4 URLs),
5.  mise à jour de web2,
6.  relance du frontal nginx sur web2,
7.  vérification du fonctionnement du site (parcours de 3 ou 4 URLs).

Attention : si un service de Publik est redémarré alors que PostgreSQL
n'est pas disponible, ce démarrage ne fonctionnera pas. Il faudra
redemander le démarrage explicitement. Ceci signifie qu'il est très
fortement conseillé de faire la mise à jour de Publik indépendamment de
celle de PostgreSQL. Entr'ouvert conseille de faire la mise à jour de
PostgreSQL **avant** les composants de Publik.

Les composants de Publik sont livrés sous forme de paquet Debian, leur
mise à jour suit la procédure classique :

    # apt update
    # apt upgrade

Il est cependant possible qu'une nouvelle version demande l'installation
d'une nouvelle dépendance, dans ce cas « *apt upgrade* » refusera la
mise à jour et il faudra la forcer par :

    # apt full-upgrade

## Mise à jour PostgreSQL

La mise à jour de PostgreSQL peut être faite à chaud selon les
procédures Debian normales. Durant la mise à jour, les services ne
fonctionneront pas (réponses 5xx) et HAProxy délivrera une erreur «
maintenance ». Dès le redémarrage de PostgreSQL, les services Publik
rétabliront les connexions vers le serveur SQL et le système sera à
nouveau utilisable.

Attention : si un service de Publik est démarré ou redémarré alors que
PostgreSQL n'est pas disponible, ce démarrage ne fonctionnera pas. Il
faudra redemander le démarrage explicitement.
