# API Publik

## Description générale

L’API des webservices Publik permet aux briques d’échanger des données.
La plupart ont trait à l’échange de données autour d’un usager.

Fournisseurs d’API :

-   w.c.s. est la brique qui propose le plus de webservices autour des
    demandes d’un usager (<https://doc-publik.entrouvert.com/dev/wcs/api-webservices/>) ;
-   Passerelle met en place des connecteurs dont la plupart ont pour
    objectif de remonter les informations d’un système tiers concernant
    un usager ;
-   Passerelle est aussi utilisé pour remonter des informations de type
    « référentiels » depuis des systèmes tiers ;
-   Authentic propose des API permettant la gestion des rôles, des
    usagers (attributs et rôles).

Consommateurs d’API :

-   Combo est un consommateur de ces API afin de présenter à l’usager
    l’ensemble des données que Publik connaît le concernant ;
-   w.c.s. utilise les API de passerelle pour présenter des référentiels
    dans les formulaires ;
-   w.c.s. utilise les API d’Authentic dans ses actions de workflow afin
    de pouvoir gérer les rôles d’un usager qui a fait une certaine
    demande ;
-   w.c.s. peut également faire appel à tout webservice de Passerelle
    afin d’intervenir sur un système tiers, toujours lors d’action de
    workflow (typiquement pour injecter des données dans un
    système tiers).

![Logo Publik](images/api.png)

## Exemple d’un dialogue Combo / w.c.s.

Objectif : lorsque l’usager se connecte sur son portail usager, une
cellule de la page affiche la liste de ses demandes en cours. Pour cela,
combo va faire appel à différents webservices de w.c.s. qui lui
retourneront les informations nécessaires à afficher dans les cellules
de la page.

![Logo Publik](images/combo.png)

## Messagerie pour **provisioning**

Le système de provisioning des utilisateurs et des rôles opère via un
diffuseur de message AMQP (RabbitMQ). Lorsqu’une modification est
effectuée sur la brique authentic, celle-ci diffuse un message à
l’attention de toutes les instances des autres briques concernées. Le
message est reçu par tous les agents de toutes les machines de
l’infrastructure, et est diffusé aux briques concernées, qui se chargent
de modifier les utilisateurs des instances cibles.

![Logo Publik](images/provisioning.png)
