# Déploiement des instances

Attention le déploiement ne doit être lancé que si TOUS les services
ont été testés et répondent des 404 aux adresses prévues.

## Préparation, création du fichier «recipe»

Création d'un fichier de déploiement
*recipe-macollectivite-prod.json*
(note : fichier déjà disponible sur l'infra de pré-prod); la ligne
"password" est à compléter le mot de passe à communiquer à Entr'ouvert :

    {
        "variables": {
            "hobo": "hobo-moncompte.macollectivite.fr",
            "authentic": "connexion-moncompte.macollectivite.fr",
            "combo": "moncompte.macollectivite.fr",
            "combo_agent": "agents-moncompte.macollectivite.fr",
            "passerelle": "passerelle-moncompte.macollectivite.fr",
            "wcs": "demarches-moncompte.macollectivite.fr",
            "fargo": "portedoc-moncompte.macollectivite.fr"
        },
        "steps": [
            {"create-hobo": {
                "url": "https://${hobo}/"
            }},
            {"create-superuser": {
                 "email": "admin+macollectivite@entrouvert.com",
                 "password": "..."
            }},
            {"create-authentic": {
                "url": "https://${authentic}/",
                "title": "Connexion"
            }},
            {"set-idp": { }},
            {"create-combo": {
                "url": "https://${combo}/",
                "title": "Compte citoyen",
                "template_name": "portal-user"
            }},
            {"create-combo": {
                "url": "https://${combo_agent}/",
                "slug": "portal-agent",
                "title": "Portail agent",
                "template_name": "portal-agent"
            }},
            {"create-wcs": {
                "url": "https://${wcs}/",
                "title": "Démarches",
                "template_name": "modele.zip"
            }},
            {"create-fargo": {
                "url": "https://${fargo}/",
                "title": "Porte-documents"
            }},
            {"create-passerelle": {
                "url": "https://${passerelle}/",
                "title": "Passerelle"
            }},
            {"set-theme": {
                "theme": "publik"
            }}
        ]
    }

Le fichier de déploiement ci-dessus mentionne un fichier template, **modele.zip**, nécessaire au paramétrage de W.C.S lors du déploiement. Ce fichier zip doit être placé dans /var/lib/wcs/skeletons.
Il peut être obtenu à partir d‘un export de site (dans l‘IHM : *Paramètres >> Export*).
Alternativement il peut-être créé manuellement : le zip doit contenir un fichier *site-options.cfg* et un fichier *config.json*, voir les exemples ci-dessous.

Pour *config.json* :

{
    "branding": {
        "theme": "clapotis-les-canards"
    },
    "debug": {
        "error_email": "admin@yourdomain.com"
    },
    "emails": {
        "from": "noreply@yourdomain.com"
    },
    "language": {
        "language": "fr"
    },
    "misc": {
        "charset": "utf-8",
        "homepage-redirect-url": "[portal_url]"
    },
    "postgresql": {
        "createdb-connection-params": {
            "database": "postgres",
            "host": "your.postgres.db.host",
            "port": "5432",
            "user": "yourdbuser",
            "password": "yourdbpassword"
        },
        "database-template-name": "wcs_%s",
        "host": "your.postgres.db.host",
        "port": "5432",
        "user": "yourdbuser",
        "password": "yourdbpassword" }
}

L‘utilisateur postgres mentionné doit avoir le droit de créer une base de donnée.

Pour *site-options.cfg* :

[options]
postgresql = true
default-to-global-view = true
workflow-global-actions = true
workflow-criticality-levels = true
workflow-resubmit-action = false
workflow-functions-only = true
formdef-captcha-option = false
default_position = 48.8336428;2.3233045

## Lancement du déploiement

On utilise la commande «cook» proposée par le logiciel «hobo». Cette
commande doit impérativement être exécutée par l'utilisateur «hobo», on
utilise donc *sudo -u hobo … :*

    # sudo -u hobo hobo-manage cook /chemin/vers/recipe-macollectivite-prod.json -v 2

## Vérification du déploiement

A la fin du déploiement, les logiciels Publik Django packagés doivent
avoir déployé les instances dans PostgreSQL (schémas visibles dans
chaque base) mais surtout crée le répertoire contenant la configuration
du site cible :

Ce qui est visible dans la plateforme de pré-production doit l'être sur
la plate-forme de production, donc on doit voir ceci (en retirant les
*preprod-*) :

    # ls -ld /var/lib/*/tenants/*
    drwxr-xr-x 3 authentic-multitenant authentic-multitenant   120 Jul 12 15:19 /var/lib/authentic2-multitenant/tenants/connexion-preprod-moncompte.macollectivite.fr
    drwxr-xr-x 5 combo                 combo                   156 Jul 21 00:25 /var/lib/combo/tenants/agents-preprod-moncompte.macollectivite.fr
    drwxr-xr-x 5 combo                 combo                  4096 Jul 20 10:38 /var/lib/combo/tenants/preprod-moncompte.macollectivite.fr
    drwxr-xr-x 3 fargo                 fargo                   107 Jul 10 18:19 /var/lib/fargo/tenants/portedoc-preprod-moncompte.macollectivite.fr
    drwxr-xr-x 3 hobo                  hobo                     81 Apr 18 10:42 /var/lib/hobo/tenants/hobo-preprod-moncompte.macollectivite.fr
    drwxr-xr-x 3 passerelle            passerelle              107 Jul 10 18:19 /var/lib/passerelle/tenants/passerelle-preprod-moncompte.macollectivite.fr

w.c.s. créé directement une base de données
*wcs_demarches_moncompte_macollectivite_fr*
accompagnée de son dossier dans */var/lib/wcs*

    # ls -ld /var/lib/wcs/*
    drwxr-xr-x 7  root  root    66 Apr 13 15:55 /var/lib/wcs/collectstatic
    -rw------- 1  root  root    50 Apr 13 15:55 /var/lib/wcs/config.pck
    drwxr-xr-x 22 wcs   wcs   4096 Jul 10 18:19 /var/lib/wcs/demarches-preprod-moncompte.macollectivite.fr
    drwxr-xr-x 2  root  root    47 Apr 13 15:59 /var/lib/wcs/skeleton.invalid
    drwxr-xr-x 2  root  root    23 Apr 13 16:00 /var/lib/wcs/skeletons

Si les répertoires sont présents, alors :

-   https://moncompte.macollectivite.fr : doit afficher une page "Votre installation de Combo
    fonctionne (...) Le site est actuellement vide (…)",
-   https://agents-moncompte.macollectivite.fr même chose,
-   https://connexion-moncompte.macollectivite.fr : doit proposer une
    page de connexion avec un design proche de la pré-prod,
-   https://passerelle-moncompte.macollectivite.fr : doit re-diriger
    vers le site connexion-moncompte précédent,
-   https://hobo-moncompte.macollectivite.fr : même chose, redirection vers connexion-moncompte,
-   https://portedoc-moncompte.macollectivite.fr : même chose, redirection vers connexion-moncompte,
-   https://demarches-moncompte.macollectivite.fr    : doit rediriger vers
    https://moncompte.macollectivite.fr/.

## Configuration de la gestion des identités

### Configuration de l'authentification LDAP

Création d'un fichier
*/var/lib/authentic2-multitenant/tenants/connexion-moncompte.macollectivite.fr/settings.json.*

(Conseil : si possible, prendre modèle sur le fichier identique en pré-prod et
adapter les paramètres LDAP).

    {
        "ACCOUNT_ACTIVATION_DAYS": 1,
        "PASSWORD_RESET_TIMEOUT_DAYS": 1,
        "A2_REGISTRATION_EMAIL_IS_UNIQUE": true,
        "A2_EMAIL_IS_UNIQUE": true,
        "LDAP_AUTH_SETTINGS": [
            {
                "realm": "mairie-macollectivite.fr",
                "url": ["ldap://v-dc1.vnan.intra/", "ldap://v-dc2.vnan.intra/"],
                "basedn": "OU=macollectivite,DC=vnan,DC=intra",
                "binddn": "xxxxx@vnan.intra",
                "bindpw": "xxxxx",
                "user_filter": "(&(objectClass=user)(sAMAccountType=805306368)(|(mail=%s)(samaccountname=%s))(|(memberOf=CN=.LD_Agents_BO,OU=macollectivite,DC=vnan,DC=intra)(memberOf=CN=.LD_Agents_Publik,OU=macollectivite,DC=vnan,DC=intra)))",
                "username_template": "{samaccountname[0]}@{realm}",
                "update_username": true,
                "active_directory": true,
                "attributes": [
                    "mail",
                    "sAMAccountName",
                    "cn",
                    "sn",
                    "givenName",
                    "userPrincipalName"
                ],
                "external_id_tuples": [["samaccountname"],["dn:noquote"]],
                "shuffle_replicas": false,
                "require_cert": "never",
                "use_tls": false,
                "set_mandatory_roles": ["Agent"],
                "user_can_change_password": false
            },
            {
                "realm": "entrouvert.com",
                "url": "ldaps://ldap.entrouvert.org/",
                "basedn": "o=entrouvert,ou=companies,o=libre-entreprise",
                "user_filter": "uid=%s",
                "username_template": "{uid[0]}@{realm}",
                "groupsu": ["cn=ldapadmins,ou=groups,o=entrouvert,ou=companies,o=libre-entreprise"],
                "groupstaff": ["cn=ldapadmins,ou=groups,o=entrouvert,ou=companies,o=libre-entreprise"],
                "group_filter": "(&(uniqueMember={user_dn})(objectClass=legroup))",
                "create_group": true,
                "attributes": [ "uid" ],
                "set_mandatory_groups": ["LDAP Entrouvert"],
                "user_can_change_password": false
            }
        ]
    }

Lancer un import manuel des comptes (pour ne pas attendre le cron)
avec :

    # sudo -u authentic-multitenant authentic2-multitenant-manage tenant_command sync-ldap-users -d connexion-moncompte.macollectivite.fr

Cette commande ne doit rien afficher (ce qui signifie que tout s'est
bien déroulé), les comptes doivent être visibles dans
[https://connexion-moncompte.macollectivite.fr/manage/users/](https://connexion-moncompte.macollectivite.fr/manage/users/)
