# Création des bases de données

## Vue générale

Chaque brique utilise une ou plusieurs bases de données PostgreSQL. Il
est courant d’utiliser une installation à deux machines identiques en
master/slave. Publik peut utiliser un système PostgreSQL existant, le
cas échéant. Publik nécessite PostgreSQL en version 9 (>=9.6 recommandée).

## Installation de PostgreSQL

Vérifier que les extensions PostgreSQL est installé :

    apt install postgresql

## Création automatisée des bases de données:

Nous proposons un script pour la création des base-de-données (distribué via le
paquet publik-common), l'utilisation standard s'adresse à un cluster postgresql
local :

    publik-create-databases

## Création manuelle des bases

Chaque composant Publik doit disposer :

-   d'une base de données dédiée,
-   d'un accès spécifique à cette base via un usager postgreSQL dédié
    (avec un mot de passe SQL à créer pour chaque composant).

Principe pour le composant *combo :*

    CREATE USER combo PASSWORD 'indiquer-ici-le-mot-de-passe-pour-combo';

    CREATE DATABASE combo WITH OWNER = combo TEMPLATE = template0 LC_COLLATE = 'fr_FR.UTF-8' LC_CTYPE = 'fr_FR.UTF-8';

Remarques :

- *template0* et *LC_COLLATE* et *LC_CTYPE* nécessaires parce que template1 est en en_US.UTF-8.
- pour le module authentic2-multitenant, le nom du rôle est *authentic-multitenant* et le nom de la base est *authentic2_multitenant* (adaptez les commandes précitées comme suit : ``CREATE USER "authentic-multitenant"...``)

La même opération doit être répétée pour chaque brique logicielle (bien sûr à
chaque fois il faut **noter le mot de passe** choisi, il sera nécessaire par la
suite) :

-   Combo
-   Hobo
-   Authentic
-   Passerelle
-   Fargo
-   Bijoe
-   Chrono
-   Welco

Pour étendre les possibilités de recherche plein texte, il est également utile
d'activer l'extension « unaccent » dans la base de données Combo :

    CREATE EXTENSION unaccent;

Sur la base de données authentic, activer les extensions suivantes :

    CREATE EXTENSION unaccent;
    CREATE EXTENSION pg_trgm;

Une brique est spécifique : w.c.s.. Pour w.c.s., il n'y a pas besoin de
création d'une base, elle sera effectuée lors de l'instanciation. En
revanche, l'utilisateur w.c.s. sur PostgreSQL doit avoir le droit
CREATEDB, donc :

*CREATE USER wcs PASSWORD 'indiquer-ici-le-mot-de-passe-pour-wcs'
CREATEDB;*
