# Prérequis d'infrastructure

## Machine hôte

Les ressources nécessaires varient en fonction de la quantité de données à
traiter. Une installation de développement peut aisément tenir sur une machine
virtuelle. Lors d'installations critiques nous isolons les composants sur des
machines séparées.

Par exemple, voici les ressources d'une machine applicative standard:

 * CPU 4 cœurs
 * 16 Go de mémoire vive
 * 200 Go d'espace disque
 * Debian 10 installé en architecture amd64 (installation minimale)

Les briques w.c.s. (formulaires) et fargo (porte-documents) doivent disposer
d’un volume plus important pour gérer les documents des usagers. Ceux-ci sont
stockés sur le système de fichier, son volume est donc à évaluer en fonction de
l’usage prévu.

## Réseau

Les ports réseaux suivants doivent être ouverts, sans filtre (très important!) et sans proxy:

 * en entrée:
     * SSH (22/tcp)
     * HTTPS (443/tcp)
     * AMPQ (5671/tcp) (au cas où les applicatifs sont répartis sur plusieurs machines)

 * en sortie:
     * SMTP (25/tcp)
     * DNS (53/udp et 53/tcp)
     * HTTP et HTTPS (80/tcp et 443/tcp)
     * PostgreSQL (5432/tcp)
     * LDAP (389/tcp et 636/TCP)
     * AMPQ (5671/tcp) (au cas où les applicatifs sont répartis sur plusieurs machines)

## Certificat X509

Publik utilise le protocole de transport chiffré HTTPS.

Un ou plusieurs certificats x509 valides et reconnus sont requis; ceux-ci
doivent couvrir tous les noms des briques qui seront installées. Pratiquement
un certificat *wildcard* suffit générallement. (un certificat wildcard couvrant
\*.demarches.macollectivite.fr et demarches.collectivite.fr) L’utilisation de
certificats Letsencrypt est possible et encouragée.

Dans la suite de la documentation nous considérons qu'un certificat est
disponible via les fichiers suivants:

 * clé publique certifiée : /etc/ssl/certs/cert-example.pem
 * clé privée : /etc/ssl/private/cert-example.key

## Résolution de noms

Avant l'installation de Publik il faut vérifier que les enregistrements
DNS sont fonctionnels; Publik nécessite autant de domaines que de
composants.

Typiquement :

-   portail usager (composant combo) :
    moncompte.macollectivite.fr,
-   portail agents (composant combo) :
    agents-moncompte.macollectivite.fr,
-   démarches (composant wcs/wcs-au-quotidien) :
    demarches-moncompte.macollectivite.fr,
-   fournisseur d'identités (composant authentic) :
    connexion-moncompte.macollectivite.fr,
-   hub de webservice (composant passerelle) :
    passerelle-moncompte.macollectivite.fr,
-   porte document (composant fargo) :
    portedoc-moncompte.macollectivite.fr,

Par exemple voici à quoi pourraient ressembler les entrées d'un serveur Bind:

    publik         A     a.b.c.d    ; addresse IP de «publik»
    portail        CNAME publik    ; portail usage (brique: combo)
    backoffice     CNAME publik    ; portail agent (brique: combo)
    connexion      CNAME publik    ; fournisseur d'identités (brique: authentic)
    demarches      CNAME publik    ; téléservices (brique: wcs)
    passerelle     CNAME publik    ; hub de webservices (brique: passerelle)
    hobo           CNAME publik    ; système de déploiement (brique: hobo)

Toutes ces entrées DNS doivent pointer vers le proxy de répartition de charge
(dans le cas d'une installation avec répartition de charge).

Par ailleurs, les serveurs applicatifs doivent impérativement avoir un
fichier */etc/hosts* consistant.

D'avantage de détails sur les sous-domaines à configurer peuvent être consultés sur https://dev.entrouvert.org/projects/publik/wiki/URL/ .


## Horloges synchronisées

Il est indispensable que les machines soient exactement à la même
heure. Les systèmes récent utilisent *systemd-timesyncd *par défaut.
*Ntp* est également possible.

## Envois des emails

Les serveurs applicatifs doivent disposer d'un MTA local (par exemple
*exim4-daemon-light*) avec le port SMTP ouvert et capable d'expédier des mails
vers tout Internet, en passant éventuellement par un relais. Les mails seront
envoyés avec le domaine « @macollectivite.fr ». Nous recommandons
vivement de les relayer via un smarthost officiel de votre réseau.

Pour d'avantage de détails sur l'envoi de courriel se référrer à https://dev.entrouvert.org/projects/publik/wiki/Envois_de_courriels .

## Configuration de la localisation

Sur toutes les machines il est nécessaire de reconfigurer la locale utilisée
par défault pour utiliser *fr_FR.UTF-8*:

    dpkg-reconfigure locales
