Autres infrastructures possibles
--------------------------------

### Infrastructure PoC / test

Dans le cadre d’une installation de test ou PoC (preuve de concept) il
est habituel d’installer Publik sur une seule machine. Dans ce cas,
toutes les briques partagent :

-   un seul frontal ngnix
-   un seul serveur de base de donnée
-   des espaces disques locaux (*/var/lib/brique*)
-   un système de log (en général le *syslog* système)

Dans ce cadre, Publik peut être installé sur une machine aujourd’hui
habituelle :

-   processeur x86-64 double cœur
-   mémoire vive 2Go
-   espace disque 10Go, voire moins

Cependant et pour rappel, Publik nécessitant un fonctionnement HTTPS, il
reste nécessaire de disposer :

-   d’un enregistrement DNS par brique instanciée ;
-   d’un certificat x509 valable pour chaque brique, généralement un
    wildcard sur le domaine choisi.

### Infrastructure légère et « élastique »

Entre une infrastructure SaaS telle que celle gérée par Entr’ouvert
capable de répondre à des dizaines d’installations, et une
infrastructure minimale telle que celle décrite pour un PoC, toutes les
combinaisons sont possibles.

La partie la plus délicate à gérer est souvent la partie x509, et
parfois la partie DNS quand il est question de pouvoir créer de
nouvelles instances automatiquement dans le cadre d’un ensemble de
communes (syndicat, organisme, métropole ou agglomération désirant
diffuser la solution Publik à ses « membres »).

Pour rendre l’installation « élastique », c’est-à-dire capable de
s’adapter au futur, il est conseillé :

-   de virtualiser toutes les machines ;
-   d’utiliser une technique de virtualisation permettant des
    modifications CPU, RAM et disque faciles, idéalement à chaud ;
-   de disposer d’un serveur PostgreSQL central ;
-   d’avoir accès à un SAN pour le stockage des données ;
-   d’avoir toute liberté sur la partie DNS, éventuellement via des
    CNAME ou une délégation de zone ;
-   de disposer d’un certificat x509 wildcard pour chaque domaine
    à gérer.

Une fois l’installation effectuée, il est souvent assez simple de
permettre le déplacement d’une brique vers une autre machine : copie des
configurations et des données, modification DNS, l’opération
correctement préparée est sans risque et ne provoque pas de coupure de
plus de 10 minutes.

### Infrastructure pour hébergement sur site

Un hébergement sur site est de type « élastique » (cf *supra*), voici
les recommandations d’usage pour l’initialisation :

-   machine « IdP » pour authentic (utilisable par d'autres systèmes
    que Publik)
-   machine « applications » : hobo + combo + w.c.s. + fargo +
    passerelle
-   machine PostgreSQL
-   autres briques sur une autre machine ou sur la machine
    « applications »
-   backups et redondance (*fail-over*) assurés par ailleurs

Pour une collectivité avec plusieurs déploiements prévus à
l’initialisation, la machine « applications » peut être scindée :

-   machine hobo + combo + passerelle
-   machine w.c.s. + fargo (porte-documents)
-   autres briques sur une machine tierce

Toutes les machines sont virtuelles et modifiables rapidement (CPU et
RAM) avec une marge importante. Les répertoires de données proviennent
d'un SAN et sont extensibles, principalement pour w.c.s. et fargo
(porte-documents).

Caractéristiques d’une machine virtuelle à l’initialisation :

-   processeur x86-64 4 cœurs
-   mémoire vive 4Go
-   espace disque 16Go ; et plus (via SAN) sur les applications stockant
    des documents w.c.s. et fargo.

Le serveur PostgreSQL est sécurisé, c’est-à-dire qu’il dispose au moins
d'un réplicat pour *fail-over*. Si besoin il peut être installé par
Entr’ouvert.

Accès à un S.I. tiers
---------------------

Lorsque Publik doit accéder à un système d’information tiers, il doit y
avoir ouverture des flux nécessaires :

-   accès webservices : passerelle consomme ou fourni des webservices
    au S.I. tiers ;
-   accès LDAP pour les annuaires : accès par l’IdP pour
    authentification et synchonisation.

Pour les webservices, la connexion sera effectuée par Passerelle, via un
connecteur.

Si le connecteur n’existe pas encore et doit donc être programmé, les
webservices tiers doivent utiliser des protocoles ouverts et reconnus,
tels que REST/JSON ou SOAP. Ils doivent être documentés et validés.

### Protection des accès webservices

![Logo Publik](images/flux_si_tiers.png)

Les webservices, en entrée comme en sortie, doivent utiliser HTTPS.
L’authentification peut être :

-   en login/mot de passe (*HTTP Basic authentication*)
-   par certificat X509 client et serveur
-   … tout autre mode d’authentification peut être étudié
    par Entr’ouvert.

Note : les API internes à Publik utilisent un système d’authentification
spécifique similaire à JWT, décrit dans
<http://doc.entrouvert.org/wcs/dev/#api>

Note 2 : En cas de proxy sur la chaîne, il faut vérifier l’absence de
cache.

### Protection de l’accès LDAP : X509

La connexion LDAP doit se faire en TLS, avec des certificats X509
clients et serveurs validés de chaque côté. Entr’ouvert peut fournir des
certificats depuis son AC privée.

S’il s’agit d’un accès LDAP à un système Active Directory, voici deux
documentation concernant la mise en place de TLS sur ce système :

-   [http://social.technet.microsoft.com/wiki/contents/articles/2980.ldap-over-ssl-ldaps-](http://social.technet.microsoft.com/wiki/contents/articles/2980.ldap-over-ssl-ldaps-certificate.aspx)[certificate.aspx](http://social.technet.microsoft.com/wiki/contents/articles/2980.ldap-over-ssl-ldaps-certificate.aspx)
-   <http://www.javaxt.com/Tutorials/Windows/How_to_Enable_LDAPS_in_Active_Directory>

### Ajout de protections sur webservices existants

Au cas où les logiciels tiers ne mettent pas en place de protection
suffisante sur leurs webservices, plusieurs solutions de sécurisation
peuvent être envisagées, dont les plus classiques sont : ajout d’un
reverse-proxy, ajout d’une instance « locale » de Passerelle, mise en
place d’un VPN.

#### Ajout d’un *reverse-proxy* 

Un reverse-proxy est placé en frontal devant les webservices, ajoutant
la couche HTTPS et/ou une authentification (par HTTP Basic ou X509).
C’est généralement la solution la plus efficace, simple à mettre en
place et ne nécessitant qu’une maintenance classique, qui peut être
intégrée à la maintenance générale du SI. C’est donc la solution
conseillée.

![Logo Publik](images/reverse_proxy.png)

Le reverse-proxy est une solution de type Apache ou Nginx. Il est
connecté d’une part au webservice à diffuser, et d’autre part à un
réseau accessible par Publik. Il ajoute :

-   le chiffrage du flux (HTTPS) ;
-   une authentification : soit basique, soit basée sur un certificat
    X509 client ;
-   un filtrage des URLs accessibles ou non depuis telle ou telle IP
    (typiquement pour l’IP de la passerelle Publik).

Un filtrage IP général peut également être ajouté au niveau d’un
firewall placé en amont du reverse-proxy, par exemple le firewall
d’arrivée générale du site client. Ce filtrage n’autorisera que l’IP de
Passerelle à accéder aux webservices.

#### Ajout d’une instance Passerelle « locale »

Dans cette configuration, une instance de Passerelle est ajoutée, au
même niveau qu’un reverse-proxy (*cf* supra). Les connecteurs de
Passerelle assurent alors localement la traduction des webservices tiers
en webservices Publik, ces derniers ajoutant la sécurisation de l’accès
entre le SI et Publik.

Cette solution présente l’avantage d’assurer un contrôle de sécurité
fort des webservices diffusés à destination de Publik, contrôle assuré
par Publik. Cependant, la maintenance est plus complexe que
l’installation d’un reverse-proxy. Aussi ne doit-elle être mise en place
que si les webservices de l’application sont très difficiles à
sécuriser.

![Logo Publik](images/passerelle_locale.png)



### MCO par Entr'ouvert

Pour qu'ils puissent assurer le maintien en conditions opérationnelles
(MCO) de la partie logicielle Publik, les travailleurs d'Entr'ouvert
doivent :

-   avoir un accès SSH aux machines le plus direct possible (sans
    nécessité de passer par un VPN, qui plus est s'il est propriétaire
    ou exotique). Entr’ouvert peut indiquer une liste d’adresses IPv4
    source ;
-   disposer d'un accès administrateur (root) sur les machines, via *su*
    ou *sudo*.

Cet accès n’est pas demandé sur les machines d’infrastructure « non
logicielle » telle que le serveur de base de données PostgreSQL, le
serveur de log, les backups, etc. La maintenance de ces systèmes est
laissée aux opérateurs habituels du site ; sauf contrat spécifique avec
Entr’ouvert.

Si l'accès web à la solution est fermé, par exemple dans le cas d'un PoC
ou d'une utilisation interne, alors cet accès doit être possible pour
Entr'ouvert (là encore, accès direct sans VPN si possible).

Si les permissions *root* sont impossibles, il est au moins nécessaire,
pour des raisons de support, qu'Entr'ouvert accéde facilement aux logs
des machines voire à son système de supervision, et ce en temps réel. Il
doit par ailleurs exister une procédure de passage root en cas
d'urgence. Enfin, si Entr'ouvert n'a pas d'accès *root* à la machine,
cela signifie que la supervision et les mises à jour régulières (au
moins quotidiennes) sont opérées par l'hébergeur ; condition sans
laquelle Entr'ouvert ne peut pas garantir une sécurité maximale du
système.

Enfin, Entr’ouvert ne peut assurer un MCO efficace que sur des machines
Debian GNU/Linux maintenues à jour – cette maintenance peut même être
assurée par Entr’ouvert. Pour tout autre système d’exploitation, un
contrat spécifique doit être prévu.

