# Haute disponiblité

Ce chapitre présente des moyens permettant d'ajouter de la redondance en vue de
garantir la disponibilité d'une installation de Publik. La charge des
opérations est dès lors répartie sur plusieurs machines; et le service est
maintenu en cas de panne d'un des composants.

## Pré-requis

Se référer aux <a href='../pre-requis/'>pré-requis</a> généraux, avec les
différences suivantes:

 * 2 machines hôtes identiques (ici nommées *web1* et *web2*) disposant des
   ressources suivantes:

   * CPU 8 cœurs
   * 32Go de mémoire vive
   * 100Go d'espace disque
   * Debian 10 installé en architecture amd64 (installation minimale)

 * un service frontal HAProxy (géré par le client)
 * un service de base de données PostgreSQL disposant de 200Go d'espace (cluster
   géré par le client)
 * un service de partage de fichiers NFS disposant de 200Go d'espace (cluster
   géré par le client)

## Installation des composants

### Création des utilisateurs avec UID identiques sur web1 et web2

Lors de partage de fichiers sur un réseau (NFS par exemple), il faut que les
UID des utilisateurs Unix concernés soient les mêmes sur les deux machines web1
et web2.

Nous fournissons un script pour faire cela :

  publik-create-users

Alternativement vous pouvez utiliser :

    #!/bin/sh

    uid=2102

    for user in hobo authentic-multitenant wcs passerelle combo fargo welco chrono bijoe
    do
        echo "create group $user ($uid)"
        addgroup --system --gid $uid $user
        echo "create user $user ($uid)"
        adduser --disabled-password --system --uid $uid --gecos "$user daemon" --ingroup $user --no-create-home --home /var/lib/$user $user
        uid=$(($uid+1))
    done

Résultat dans /etc/passwd:

    hobo:x:2102:2102:hobo daemon,,,:/var/lib/hobo:/bin/false
    authentic-multitenant:x:2103:2103:authentic2-multitenant daemon,,,:/var/lib/authentic2-multitenant:/bin/false
    wcs:x:2104:2104:wcs daemon,,,:/var/lib/wcs:/bin/false
    passerelle:x:2105:2105:passerelle daemon,,,:/var/lib/passerelle:/bin/false
    combo:x:2106:2106:combo daemon,,,:/var/lib/combo:/bin/false
    fargo:x:2107:2107:fargo daemon,,,:/var/lib/fargo:/bin/false
    welco:x:2108:2108:welco daemon,,,:/var/lib/welco:/bin/false
    chrono:x:2109:2109:chrono daemon,,,:/var/lib/chrono:/bin/false
    bijoe:x:2110:2110:bijoe daemon,,,:/var/lib/bijoe:/bin/false


### Vue générale

Avant l'installation des modules, il faut pour chacun d'eux (sauf w.c.s.)
configurer l'accès au PostgreSQL; par exemple, dans
*/etc/combo/settings.d/macollectivite.py* :

    DATABASES['default']['NAME'] = 'combo'
    DATABASES['default']['USER'] = 'combo'
    DATABASES['default']['PASSWORD'] = 'indiquer-ici-le-mot-de-passe-pour-combo'
    DATABASES['default']['HOST'] = 'sql-prod'
    DATABASES['default']['PORT'] = '5432'

Suivre ensuite les instructions pour une installation mono-machine. Ensuite
déplacer les éléments de configuration vers le partage de fichiers :

 * les répertoires de configuration `/etc/xxx` des composants Publik,
   copiés vers `/srv/nfs/publik/etc/xxx,`
 * les données `/var/lib/xxx` de ces mêmes composants, copiés vers
   `/srv/nfs/publik/var/lib/xxx,`
 * la configuration nginx ; copiés vers `/srv/nfs/publik/etc/nginx/xxx`
   et `/srv/nfs/publik/var/www/html`.

Sur *web1* et *web2* nous pointons les fichiers partagés à l'aide de liens
symboliques :

 * Configuration : `/etc/xxx` → `/srv/nfs/publik/etc/xxx,`
 * Données : `/var/lib/xxx` → `/srv/nfs/publik/var/lib/xxx,`
 * Configuration nginx.

### Détail des opérations

Création des répertoires partagés :

 * Configuration: `/srv/nfs/publik/etc`,
 * Données des tenants: `/srv/nfs/publik/var/lib/`
 * Données statiques: `/srv/nfs/publik/var/www/`

Déplacement des configurations et données des services Publik:

1.  Service *wcs*

        service wcs stop
        mv /etc/wcs /srv/nfs/publik/etc/
        ln -sf /srv/nfs/publik/etc/wcs /etc/wcs
        mv /var/lib/wcs /srv/nfs/publik/var/lib/
        ln -sf /srv/nfs/publik/var/lib/wcs /var/lib/wcs
        service wcs start

2.  Service *combo*

        service combo stop
        mv /etc/combo /srv/nfs/publik/etc/
        ln -sf /srv/nfs/publik/etc/combo /etc/combo
        mv /var/lib/combo /srv/nfs/publik/var/lib/
        ln -sf /srv/nfs/publik/var/lib/combo /var/lib/combo
        service combo start

3.  Même procédure avec *fargo*
4.  Même procédure avec *passerelle*
5.  Même procédure avec *hobo*
6.  Même procédure avec *authentic2-multitenant*
7.  Configuration hobo-agent

        service supervisor stop
        mv /etc/hobo-agent /srv/nfs/publik/etc/
        ln -sf /srv/nfs/publik/etc/hobo-agent /etc
        service supervisor start

Autres partages via NFS :

1.  Configurations nginx

        service nginx stop
        mkdir /srv/nfs/publik/etc/nginx
        cd /etc/nginx
        mv conf.d includes sites-available sites-enabled /srv/nfs/publik/etc/nginx/
        ln -sf /srv/nfs/publik/etc/nginx/* .
        service nginx start

2.  Éléments web statiques

        cd /var/www
        mv html /srv/nfs/publik/var/www/
        ln -sf /srv/nfs/publik/var/www/html .

3.  APT : dépôts et préférences backports

        mkdir /srv/nfs/publik/etc/apt
        cd /etc/apt
        mv sources.list.d preferences.d /srv/nfs/publik/etc/apt/
        ln -sf /srv/nfs/publik/etc/apt/* .

### Opérations sur web2

**Attention** : l'UID et le GUID de l'utilisateur *www-data* doit être
identique.

Préparer les répertoires de configuration et de données des composants
Publik **avant** leur installation :

1.  Service wcs

        ln -sf /srv/nfs/publik/etc/wcs /etc/wcs
        ln -sf /srv/nfs/publik/var/lib/wcs /var/lib/wcs

2.  Service *combo*

        ln -sf /srv/nfs/publik/etc/combo /etc/combo
        ln -sf /srv/nfs/publik/var/lib/combo /var/lib/combo

3.  Même procédure avec *fargo*
4.  Même procédure avec *passerelle*
5.  Même procédure avec *hobo*
6.  Même procédure avec *authentic2-multitenant*
7.  Configuration hobo-agent

        ln -sf /srv/nfs/publik/etc/hobo-agent /etc/hobo-agent

Préparer la configuration des autres composants:

1.  Configurations nginx

        service nginx stop
        cd /etc/nginx
        rm -rf conf.d includes sites-available sites-enabled
        ln -sf /srv/nfs/publik/etc/nginx/* .
        service nginx start

2.  Éléments web statiques

        cd /var/www
        rm -rf html
        ln -sf /srv/nfs/publik/var/www/html .

3.  APT : dépôts et préférences backports

        cd /etc/apt
        rm -rf sources.list.d preferences.d
        ln -sf /srv/nfs/publik/etc/apt/* .

Lancer l'installation des composants packagés. Attention, lors de cette étape,
toujours refuser les éventuelles demandes de modification des fichiers de
configuration (on utilise ceux partagés par NFS) :

    apt install wcs wcs-au-quotidien
    apt install combo
    apt install fargo
    apt install passerelle
    apt install hobo
    apt install authentic2-multitenant
    apt install hobo-agent

Nous comparons la liste des paquets installés entre web1 et web2
(obtenue avec *dpkg -l*), et installons les paquets suivants :

-   python-combo-plugin-macollectivite,
-   publik-base-theme,
-   gettext

## Désactivation des *crons* Publik sur web2

Il est **très important** de désactiver les crons de Publik sur web2,
pour ne pas avoir de compétition/conflit avec ceux déjà en place sur
web1, puisqu'ils agissent sur les mêmes données.

Il faut donc poser des # devant les lignes des crons suivants :

-   */etc/cron.d/wcs,*
-   */etc/cron.d/authentic2-multitenant,*
-   */etc/cron.d/passerelle,*
-   */etc/cron.hourly/python-combo,*
-   */etc/cron.hourly/fargo.*

## Paramétrage du partage de fichiers

Démarrer les services uniquement après le montage de /srv/nfs

Ajouter pour les services liés à Publik un supplément
*RequiresMountsFor=* à la description du service

Exemple pour Combo :

    cat /etc/systemd/system/combo.service.d/wait-for-mnt-data.conf

    [Unit]

    RequiresMountsFor=/srv/nfs

Faire de même avec les services qui ont besoin de */srv/nfs* : Combo,
    Fargo, Passerelle, authentic2-multitenant, hobo, hobo-agent, wcs.
