# Configuration des dépôts logiciels

## Vue générale

Les différents composants logiciels utilisés par Publik proviennent, par
ordre de préférence :

-   de la distribution Debian GNU/Linux stable
-   des *backports* officiels Debian, disposant du suivi de sécurité par
    l’équipe Debian,
-   des paquets Debian fournis et maintenus par les projets *upstream,*
-   de paquets Debian maintenus par Entr’ouvert qui en assure le suivi
    de sécurité.

## Configuration des dépôts logiciels

Configurons le dépôt **buster-backports** :

    echo 'deb http://deb.debian.org/debian/ buster-backports main' > /etc/apt/sources.list.d/backports.list

Ajoutons aussi les dépôts Entr'ouvert:

    echo 'deb http://deb.entrouvert.org/ buster main' > /etc/apt/sources.list.d/entrouvert.list

Ajoutons la clé associée :

    wget -O- https://deb.entrouvert.org/entrouvert.gpg | apt-key add -
    apt update

Nous installons ensuite les configuration particulières de apt :

    apt install -o Dpkg::Options::="--force-confnew" entrouvert-repository
    apt install entrouvert-repository-hotfix
    apt update

## Installation des paquets de base

Outillage utile pour l'installation et plus tard pour le support et la maintenance :

    apt install postgresql-client # pour création utilisateurs et bases de données dans postgresql
    apt install bsd-mailx # pour test de l'envoi de mails
    apt install zip # pour la création du squelette de site w.c.s.
    apt install curl wget # pour les tests/debug locaux
    apt install ltrace strace psmisc tcpdump tshark # pour des debug applicatifs
    apt install ca-certificates-entrouvert # connexion au LDAP EO

Composants additionnels nécessaires pour les applications :

    apt install libreoffice # pour génération de documents dans wcs
    apt install publik-base-theme # système de thème
    apt install publik-common # outils de gestion
