# Présentation d'une brique

Une brique Entrouvert est un paquet Debian standard issu d’un module
Python standard. C’est un logiciel libre dont vous pouvez obtenir et
modifier les sources selon vos besoins. Les fichiers d’installation sont
posés dans /var/lib/mabrique, et les fichiers de configuration sont
placés dans /etc/mabrique. Les services et les journaux des briques sont
pilotés par systemd.

Note: lors d'installations critiques, nous créons un lien symbolique depuis
/var/lib/mabrique/documents vers un montage NFS.

## Utilisation de cadriciels (*frameworks*)

Chaque brique logicielle est une application Python/Django – à
l’exception de la brique w.c.s. qui utilise le cadriciel Quixote.

L’utilisation d’un *framework* permet de disposer d’un ensemble de
composants afin de développer plus rapidement, mais aussi de manière
plus homogène, et surtout en assurant à tout moment une excellente
sécurité de l’application. C’est en effet le framework qui :

-   reçoit les données, les interprète et les valide avant de les
    envoyer à l’application ;
-   permet de contrôler l’envoi des données aux bases de données par
    l’application (pas de requêtes SQL directes) ;
-   sécurise les sorties de l’application (HTML) en imposant un contrôle
    fort sur les données affichable.

Dans Publik, en plus de l’utilisation de toutes les possibilités de
Django d’autres protections sont mises en place :

-   isolation des composants (chaque composant est une brique logicielle
    indépendante) ;
-   chaque brique dispose de sa propre base de données, complètement
    isolée des autres (chaque base peut même être hébergée sur un
    serveur propre) ;
-   chaque brique peut gérer plusieurs sites (mode multi-tenants), dans
    ce cas chaque site dispose d’un « tenant » dans la base de données
    sous forme d’un schéma PostgreSQL : chaque site est donc indépendant
    et isolé ;
-   utilisation du front-end nginx pour diffuser tous les éléments
    statiques des applications ;
-   connexion de l’application via le protocole wsgi pour un premier
    filtrage des requêtes (les requêtes invalides sont
    rapidement éliminées).

D’une façon générale, Publik utilise au maximum des composants
éprouvés : le code des applications se concentre uniquement sur la
logique de celles-ci. Il s’agit de suivre les principes DRY (Don’t
Repeat Yourself) et KISS (Keep It Simple Stupid) afin de mieux sécuriser
l’application : la sobriété recherchée par Publik est aussi présente
dans le code du logiciel.

## Dialogue entre les composants

![Logo Publik](images/schema.png)

Le schéma ci-dessus montre que l’application n’est pas en contact
« direct » avec l’extérieur. Elle utilise toujours des composants
logiciels soit éprouvés (celery, requests, tenant-schemas), soit communs
à toutes les briques (hobo, mellon).

Dialogues entre briques
-----------------------

Les briques de Publik dialoguent via deux canaux :

-   webservices (HTTPS JSON) pour ce qui concerne l’échange de données
-   messages (AMQP) pour ce qui concerne la gestion des utilisateurs et
    des rôles, *i.e.* le provisioning au travers des différents
    composants

Par ailleurs SAML est utilisé pour ce qui concerne le WebSSO (le
dialogue se déroule via le navigateur de l’usager).

![Logo Publik](images/dialogue.png)

## Chemin d'une requête

Une requête Publik chemine typiquement par les services suivants :

service web (nginx) :

-  dispose d'un certificat SSL
-  dispose des composants Publik
-  interroge la base de donnée et répond aux requêtes des utilisateurs

service de base de données (postgresql) :

-  enregistre et restitue les données des applications,

