import os
import sys

from ..qommon.ctl import Command, make_option


class Cmd(Command):
    name = 'has_role'

    def __init__(self):
        super().__init__([make_option('-d', '--domain', action='store', dest='domain')])

    def execute(self, base_options, sub_options, args):
        from .. import publisher

        publisher.WcsPublisher.configure(self.config)
        publisher = publisher.WcsPublisher.create_publisher(register_tld_names=False)
        publisher.set_tenant_by_hostname(sub_options.domain)
        for role in publisher.role_class.select():
            if role.name == args[0]:
                sys.exit(0)
        sys.exit(1)


Cmd.register()
