import json

from django.contrib.auth import get_user_model
from authentic2_auth_fc.models import FcAccount

User = get_user_model()

stats = {
    'total': User.objects.all().count(),
    'logged-in': User.objects.filter(last_login__isnull=False).count(),
    'without-any-roles': User.objects.filter(roles__isnull=True).count(),
    'without-any-roles-logged-in': User.objects.filter(roles__isnull=True, last_login__isnull=False).count(),
    'franceconnect': FcAccount.objects.all().count(),
}

print(json.dumps(stats, indent=2))
