#! /usr/bin/env python3
#
# run as:
# sudo -u wcs wcs-manage runscript --domain=... index-formdefs-in-elasticsearch.py

import os
import sys

if (
    os.path.exists('/etc/wcs/settings.d/disable_cron.py')
    and 'DISABLE_CRON_JOBS = True' in open('/etc/wcs/settings.d/disable_cron.py').read()
):
    sys.exit(0)

from elasticsearch import Elasticsearch

from quixote import get_publisher
import wcs
from wcs.formdef import FormDef

if 'test' in get_publisher().app_dir:
    es = Elasticsearch([{'host': '46.18.194.234', 'port': 9200}])
else:
    es = Elasticsearch([{'host': '46.18.194.222', 'port': 9200}])

indexed_forms = es.search(index='liferay-20116', doc_type='LiferayDocumentType', q='type:procedure')
indexed_form_ids = [x['_id'] for x in indexed_forms['hits']['hits']]

for formdef in FormDef.select():
    if formdef.disabled and not formdef.disabled_redirection:
        continue
    if formdef.keywords and 'noindex' in formdef.keywords:
        continue
    url = formdef.get_url() if not formdef.disabled else formdef.disabled_redirection
    index_id = 'wcs:formdef:%s' % formdef.id
    es.index(
        index='liferay-20116',
        doc_type='LiferayDocumentType',
        id=index_id,
        body={'title': formdef.name, 'url': formdef.get_url(), 'description': '', 'type': 'procedure'},
    )
    if index_id in indexed_form_ids:
        indexed_form_ids.remove(index_id)

# remove obsolete forms
for index_id in indexed_form_ids:
    es.delete(index='liferay-20116', doc_type='LiferayDocumentType', id=index_id)
