document.addEventListener('DOMContentLoaded', ()=>{

  // on button-next click -> display page spinner (for .pwa-ui forms)
  (function () {
    const pwaForm = document.querySelector('form.pwa-ui');
    if (!pwaForm) return;

    const activeSpinner = pwaForm.querySelector('.active-spinner');
    if (!activeSpinner) return;

    const backdrop = document.createElement('div');
    backdrop.classList.add('spinner--backdrop')
    const spinner = document.createElement('div')
    spinner.classList.add('spinner')
    const text = document.createElement('p')
    text.innerText = 'Merci de patienter…'
    backdrop.append(spinner)
    backdrop.append(text)
    document.body.append(backdrop)

    pwaForm.addEventListener('submit', (e) => {
      backdrop.classList.add('show')
    })
  })()

  //
  //  Allo Toulouse Portal
  //
  const isAlloToulouse = document.body.classList.contains('portal-allo-toulouse')
  // Share button
  ;(function () {
    const shareButton = document.querySelector('#share-button')
    if (!(isAlloToulouse && shareButton && navigator.share)) return
    const url = window.location.origin
    shareButton.addEventListener('click', async () => {
      const data = { url };
      try {
        await navigator.share(data);
      }
      catch (e) {
        console.error('share error', e);
      }
    });
  })()
});
