import nox


@nox.session
def codestyle(session):
    session.install('pre-commit')
    session.run('pre-commit', 'run', '--all-files', '--show-diff-on-failure')


@nox.session
def check_manifest(session):
    # django is only required to compile messages
    session.install('django', 'check-manifest')
    # compile messages and css
    session.run('check-manifest', '--ignore', ','.join(CHECK_MANIFEST_IGNORES))


CHECK_MANIFEST_IGNORES = [
    'VERSION',
    'static/*/style.css',
    'static/*/style.css.map',
    'static/tournai/img/.empty',
    'templates/variants/boussu-2022/combo/json/*',
    'templates/variants/boussu-2022/combo/wcs/*',
    'templates/variants/eybens/authentic2_idp_oidc/authorization.html',
    'templates/variants/eybens/combo/cell-header.html',
    'templates/variants/eybens/combo/cells/liens-demarches/link-list-cell.html',
    'templates/variants/eybens/combo/cells/services-communes/link-list-cell.html',
    'templates/variants/eybens/combo/json/peps-demands.html',
    'templates/variants/eybens/combo/link-cell.html',
    'templates/variants/eybens/combo/page_template.html',
    'templates/variants/eybens/combo/wcs/form_link_fragment.html',
    'templates/variants/eybens/combo/wcs/forms_of_category.html',
    'templates/variants/eybens/combo/wcs/tracking_code_input.html',
    'templates/variants/eybens/includes/user-info-login-label.html',
    'templates/variants/eybens/includes/user-info-logout-label.html',
    'templates/variants/eybens/includes/user-info-registration-label.html',
    'templates/variants/grenoble-metropole-2022/authentic2_idp_oidc/authorization.html',
    'templates/variants/grenoble-metropole-2022/combo/cell-header.html',
    'templates/variants/grenoble-metropole-2022/combo/cells/liens-demarches/link-list-cell.html',
    'templates/variants/grenoble-metropole-2022/combo/cells/services-communes/link-list-cell.html',
    'templates/variants/grenoble-metropole-2022/combo/json/peps-demands.html',
    'templates/variants/grenoble-metropole-2022/combo/link-cell.html',
    'templates/variants/grenoble-metropole-2022/combo/page_template.html',
    'templates/variants/grenoble-metropole-2022/combo/wcs/form_link_fragment.html',
    'templates/variants/grenoble-metropole-2022/combo/wcs/forms_of_category.html',
    'templates/variants/grenoble-metropole-2022/combo/wcs/tracking_code_input.html',
    'templates/variants/grenoble-metropole-2022/includes/user-info-login-label.html',
    'templates/variants/grenoble-metropole-2022/includes/user-info-logout-label.html',
    'templates/variants/grenoble-metropole-2022/includes/user-info-registration-label.html',
    'templates/variants/grenoble/authentic2_idp_oidc/authorization.html',
    'templates/variants/grenoble/combo/cell-header.html',
    'templates/variants/grenoble/combo/cells/liens-demarches/link-list-cell.html',
    'templates/variants/grenoble/combo/cells/services-communes/link-list-cell.html',
    'templates/variants/grenoble/combo/json/peps-demands.html',
    'templates/variants/grenoble/combo/link-cell.html',
    'templates/variants/grenoble/combo/page_template.html',
    'templates/variants/grenoble/combo/wcs/form_link_fragment.html',
    'templates/variants/grenoble/combo/wcs/forms_of_category.html',
    'templates/variants/grenoble/combo/wcs/tracking_code_input.html',
    'templates/variants/grenoble/includes/user-info-login-label.html',
    'templates/variants/grenoble/includes/user-info-logout-label.html',
    'templates/variants/grenoble/includes/user-info-registration-label.html',
    'templates/variants/hellemmes/authentic2/accounts.html',
    'templates/variants/hellemmes/authentic2/base.html',
    'templates/variants/hellemmes/combo/cells/filtre-profil/text-cell.html',
    'templates/variants/hellemmes/combo/page_template.html',
    'templates/variants/hellemmes/combo/page_template_homepage.html',
    'templates/variants/hellemmes/combo/pwa/navigation.html',
    'templates/variants/hellemmes/combo/wcs/tracking_code_input.html',
    'templates/variants/hellemmes/includes/user-info-login-label.html',
    'templates/variants/hellemmes/includes/user-info-user-name.html',
    'templates/variants/hellemmes/theme.html',
    'templates/variants/hellemmes/wcs/base.html',
    'templates/variants/hellemmes/wcs/front/formdata_filling.html',
    'templates/variants/hellemmes/wcs/front/formdata_validation.html',
    'templates/variants/la-seyne-sur-mer/authentic2_auth_oidc/login.html',
    'templates/variants/lomme/authentic2/accounts.html',
    'templates/variants/lomme/authentic2/base.html',
    'templates/variants/lomme/combo/cells/filtre-profil/text-cell.html',
    'templates/variants/lomme/combo/page_template.html',
    'templates/variants/lomme/combo/page_template_homepage.html',
    'templates/variants/lomme/combo/pwa/navigation.html',
    'templates/variants/lomme/combo/wcs/tracking_code_input.html',
    'templates/variants/lomme/includes/user-info-login-label.html',
    'templates/variants/lomme/includes/user-info-user-name.html',
    'templates/variants/lomme/theme.html',
    'templates/variants/lomme/wcs/base.html',
    'templates/variants/lomme/wcs/front/formdata_filling.html',
    'templates/variants/lomme/wcs/front/formdata_validation.html',
    'templates/variants/massoins/authentic2_auth_oidc/login.html',
    'templates/variants/montelimar/combo/text-cell.html',
    'templates/variants/montelimar/includes/user-info-user-name.html',
    'templates/variants/montelimar/theme.html',
    'templates/variants/pays-de-grasse/authentic2_auth_oidc/login.html',
    'templates/variants/saint-vallier-de-thiey/authentic2_auth_oidc/login.html',
    'templates/variants/sospel/authentic2_auth_oidc/login.html',
    'templates/variants/boussu-2022/combo/json',
    'templates/variants/boussu-2022/combo/wcs',
    'templates/variants/eybens',
    'templates/variants/grenoble',
    'templates/variants/grenoble-metropole-2022',
    'templates/variants/hellemmes',
    'templates/variants/la-seyne-sur-mer',
    'templates/variants/lomme',
    'templates/variants/massoins',
    'templates/variants/montelimar',
    'templates/variants/pays-de-grasse',
    'templates/variants/saint-vallier-de-thiey',
    'templates/variants/sospel',
]
