"""
Django settings for pfwb_archives_proxy project.

Generated by 'django-admin startproject' using Django 2.2.21.

For more information on this file, see
https://docs.djangoproject.com/en/2.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/2.2/ref/settings/
"""

import os

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/2.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = '(override this in local settings)'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []


# Application definition

INSTALLED_APPS = [
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'pfwb_archives_proxy.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'pfwb_archives_proxy.wsgi.application'


# Database
# https://docs.djangoproject.com/en/2.2/ref/settings/#databases

DATABASES = {}


# Password validation
# https://docs.djangoproject.com/en/2.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/2.2/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.2/howto/static-files/

STATIC_URL = '/static/'

# DOCUMENT TYPES
TABELLIO_DOCUMENT_TYPES = {
    'accord-de-cooperation': 'ACCOP',
    'allocution-de-la-presidence': 'ALLOC',
    'amendements-en-commission': 'AMENDCOM',
    'amendements-en-seance': 'AMENDSCE',
    'annexe': 'ANNEXE',
    'arrete-de-reallocation': 'ARRREA',
    'avis': 'AVIS',
    'avis-d-une-commission-annexe': 'ACA',
    'avis-du-conseil-d-etat': 'CETAT',
    'budget-administratif': 'BUDADM',
    'budget-de-fonctionnement-du-parlement': 'BUDFONN',
    'budget-de-fonctionnement-du-parlement-sans-numero': 'BUDFON',
    'budget-de-fonctionnement-du-pcf': 'BUFONCPCF',
    'budget-de-fonctionnement-pcf': 'BUFONCPCF',
    'budget-divers': 'BUDDIVERS',
    'bulletin-des-questions-et-des-reponses': 'BQR',
    'bulletin-des-questions-et-reponses': 'BQR',
    'bulletin-des-travaux': 'BTR',
    'bureau': 'BUR',
    'cahier-d-observations': 'RP-COBS',
    'communication-de-la-presidence': 'COMMUNI',
    'composition-du-gouvernement': 'GOUVERNEM',
    'compte-rendu-analytique': 'CRA',
    'compte-rendu-de-reunion': 'CRI-RE',
    'compte-rendu-integral': 'CRI',
    'compte-rendu-integral-de-commission': 'CRICOM',
    'conference-des-presidents': 'CONFEPRE',
    'contrat-de-gestion': 'CONTRAGES',
    'controle-du-compte-general': 'CCG',
    'cri-commission': 'CRICOM',
    'debat-thematique': 'DT',
    'declaration-du-gouvernement': 'DECLAGOUV',
    'decret': 'DECCCF',
    'decret-ccf': 'DECCCF',
    'discussion-generale-conjointe': 'DICO',
    'divers': 'DIVERS',
    'eloges-funebres': 'ELOGE',
    'enquete-parlementaire': 'CREACOMEN',
    'entente': 'ENTENTE',
    'erratum': 'ERRATUM',
    'etat-des-travaux': 'ETATRA',
    'expose-general-du-budget': 'EXGEBU',
    'expose-particulier': 'EXPART',
    'interpellation': 'INTERP',
    'liste': 'LISTE',
    'liste-des-candidatures': 'LICA',
    'numero-non-attribue': 'NONO',
    'parchemin': 'PARCH',
    'plan': 'PLAN',
    'poursuite-a-charge-d-un-membre': 'PCM',
    'prefiguration-des-resultats': 'RP-PREF',
    'programme-justificatif': 'PROGJ',
    'programme-quinquennal': 'PROGQUINQ',
    'projet-de-decret': 'PJD',
    'projet-de-decret-budgetaire': 'PJDB',
    'projet-de-motion': 'DG-PJMS',
    'projet-de-resolution': 'DG-PJR',
    'proposition-de-decret': 'PPD',
    'proposition-de-modification-du-reglement': 'PPMR',
    'proposition-de-motion': 'DG-PPMS',
    'proposition-de-resolution': 'DG-PPR',
    'proposition-de-resolution-sans-numero': 'PRORESN',
    'question-d-actualite': 'QA',
    'question-ecrite': 'QE',
    'question-orale': 'QO',
    'rapport': 'RAPPORT',
    'rapport-d-activites': 'RP-RACT',
    'rapport-de-commission': 'RAPP',
    'rapport-de-verification-des-comptes': 'RAPVERI',
    'rapport-sans-numero': 'RASANU',
    'reglement-du-parlement': 'REGLPARL',
    'reglements-conjoints': 'REGLCONJ',
    'resolution': 'RESOLU',
    'resolution-adoptee-par-le-parlement': 'RESADOPT',
    'resolutions': 'RESO',
    'service-de-mediation-commun': 'SMC',
    'statut-des-agents-du-parlement': 'SAP',
    'texte-adopte': 'TEXADOPT',
    'texte-adopte-en-commission': 'TEXTCOM',
}

TABELLIO_FILTERED_TYPES = ['BTR']

local_settings_file = os.environ.get(
    'PFWB_ARCHIVES_PROXY_SETTINGS_FILE', os.path.join(os.path.dirname(__file__), 'local_settings.py')
)
if os.path.exists(local_settings_file):
    exec(open(local_settings_file).read())
