# Petale - Simple App as Key/Value Storage Interface
# Copyright (C) 2017  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from django.conf.urls import include, url
from django.contrib import admin

from .api_views import PetalAPIView, PetalAPIKeysView


urlpatterns = [
    url(r'^admin/', admin.site.urls),
    url(r'^api/(?P<partner_name>[\w,-]+)/(?P<cut_uuid>[\w,-]{,255})/$',
        PetalAPIKeysView.as_view(),
        name='api-keys'),
    url(r'^api/(?P<partner_name>[\w,-]+)/(?P<cut_uuid>[\w,-]{,255})/(?P<petal_name>[\w,-]+)/$',
        PetalAPIView.as_view(), name='api')
]
