#!/usr/bin/python3

import argparse

import utils

PERSON_ID = '263781'  # BART SIMPSON
DATE = '2024-03-18'


def check(args):
    utils.configure_logging(args.verbose)
    client = utils.get_client(args.env, 'Ape')

    result = client.service.confirmChildBirth(
        request={
            'numPerson': args.person,
            'birth': {
                'dateBirth': args.date,
            },
        },
    )
    if args.verbose > 1:
        print(result)
    return result


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--verbose', '-v', type=int, default=2, help='display errors')
    parser.add_argument('--env', '-e', default='integ', help='dev, test, integ, prod')
    parser.add_argument('--person', '-P', default=PERSON_ID, help='person id')
    parser.add_argument('--date', '-d', default=DATE, help='date (ex: 2023-02-01)')
    args = parser.parse_args()
    check(args)
