#!/usr/bin/python3

import argparse

import utils

APE_BOOK_ID = 'S6883'
DECISION_ID = 'CLOFAM'
REASON_ID = 'CLO_AMIND'


def check(args):
    utils.configure_logging(args.verbose)
    client = utils.get_client(args.env, 'Ape')

    result = client.service.processFamilyDecision(
        request={
            'idApeBook': args.book,
            'decisionCode': args.decision,
            'reasonCode': args.reason,
        },
    )
    if args.verbose > 1:
        print(result)

    return result


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--verbose', '-v', type=int, default=2, help='display errors')
    parser.add_argument('--env', '-e', default='integ', help='dev, test, integ, prod')
    parser.add_argument('--book', '-b', default=APE_BOOK_ID, help='APE book id')
    parser.add_argument('--decision', '-d', default=DECISION_ID, help='decision id')
    parser.add_argument('--reason', '-r', default=REASON_ID, help='reason id')
    args = parser.parse_args()
    check(args)
