# Generated by Django 2.2.24 on 2022-02-09 11:10

import django.contrib.postgres.fields
import django.core.validators
from django.db import migrations, models

import passerelle.sms.models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('base', '0029_auto_20210202_1627'),
    ]

    operations = [
        migrations.CreateModel(
            name='SfrDmcGateway',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'default_country_code',
                    models.CharField(
                        default='33',
                        max_length=3,
                        validators=[
                            django.core.validators.RegexValidator(
                                '^[0-9]*$', 'The country must only contain numbers'
                            )
                        ],
                        verbose_name='Default country code',
                    ),
                ),
                (
                    'default_trunk_prefix',
                    models.CharField(
                        default='0',
                        max_length=2,
                        validators=[
                            django.core.validators.RegexValidator(
                                '^[0-9]*$', 'The trunk prefix must only contain numbers'
                            )
                        ],
                        verbose_name='Default trunk prefix',
                    ),
                ),
                (
                    'max_message_length',
                    models.IntegerField(
                        default=2000,
                        help_text='Messages over this limit will be truncated.',
                        verbose_name='Maximum message length',
                    ),
                ),
                (
                    'authorized',
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(
                            choices=[
                                ('fr-metro', 'France mainland (+33 [67])'),
                                ('fr-domtom', 'France and DOM/TOM (+33, +262, etc.)'),
                                ('be', 'Belgian (+32 4[5-9]) '),
                                ('all', 'All'),
                            ],
                            max_length=32,
                            null=True,
                        ),
                        default=passerelle.sms.models.authorized_default,
                        size=None,
                        verbose_name='Authorized Countries',
                    ),
                ),
                (
                    'allow_premium_rate',
                    models.BooleanField(
                        default=False,
                        verbose_name='Allow premium rate numbers',
                    ),
                ),
                ('service_id', models.CharField(max_length=15, verbose_name='Service ID')),
                ('service_password', models.CharField(max_length=15, verbose_name='Service Password')),
                ('space_id', models.IntegerField(verbose_name='Space ID')),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'SFR DMC',
            },
        ),
    ]
