# Generated by Django 4.2.15 on 2025-11-12 19:17

from django.db import migrations

from passerelle.utils.conversion import any2bool


def migrate_revoked(apps, schema_editor):
    Event = apps.get_model('qrcode', 'Event')
    for event in Event.objects.filter(metadata__revoked__isnull=False):
        revoked = event.metadata['revoked']
        revoked_converted = any2bool(revoked)
        if revoked is not revoked_converted:
            event.metadata['revoked'] = revoked_converted
            event.save()


class Migration(migrations.Migration):

    dependencies = [
        ('qrcode', '0010_alter_event_reader'),
    ]

    operations = [
        migrations.RunPython(migrate_revoked, migrations.RunPython.noop),
    ]
