# Generated by Django 3.2.18 on 2024-05-07 09:51

import uuid

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models

import passerelle.apps.qrcode.models


def set_default_campaign(apps, schema_editor):
    QRCodeConnector = apps.get_model('qrcode', 'QRCodeConnector')
    for connector in QRCodeConnector.objects.all():
        default_campaign = connector.campaigns.create(key=connector.key)

        for certificate in connector.certificates.all():
            certificate.campaign = default_campaign
            certificate.save()

        for reader in connector.readers.all():
            reader.campaign = default_campaign
            reader.save()


def remove_campaign(apps, schema_editor):
    QRCodeConnector = apps.get_model('qrcode', 'QRCodeConnector')
    for connector in QRCodeConnector.objects.all():
        for campaign in connector.campaigns.all():
            connector.key = campaign.key
            connector.save()

            for certificate in campaign.certificates.all():
                certificate.resource = connector
                certificate.save()

            for reader in campaign.readers.all():
                reader.resource = connector
                reader.save()


class Migration(migrations.Migration):
    dependencies = [
        ('qrcode', '0006_auto_20240211_1730'),
    ]

    operations = [
        migrations.CreateModel(
            name='Campaign',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True, verbose_name='UUID')),
                (
                    'key',
                    models.CharField(
                        default=passerelle.apps.qrcode.models.generate_key,
                        max_length=64,
                        validators=[
                            django.core.validators.RegexValidator(
                                '[a-z|0-9]{64}', 'Key should be a 32 bytes hexadecimal string'
                            )
                        ],
                        verbose_name='Private Key',
                    ),
                ),
                (
                    'resource',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='campaigns',
                        to='qrcode.qrcodeconnector',
                    ),
                ),
                (
                    'created',
                    models.DateTimeField(auto_now_add=True, verbose_name='Created'),
                ),
                (
                    'modified',
                    models.DateTimeField(auto_now=True, verbose_name='Last modification'),
                ),
                (
                    'metadata',
                    models.JSONField(null=True, verbose_name='Campaign meta data'),
                ),
            ],
        ),
        migrations.AddField(
            model_name='certificate',
            name='campaign',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='certificates',
                to='qrcode.campaign',
            ),
        ),
        migrations.AddField(
            model_name='reader',
            name='campaign',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='readers',
                to='qrcode.campaign',
            ),
        ),
        migrations.AlterField(
            model_name='certificate',
            name='resource',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='certificates',
                to='qrcode.qrcodeconnector',
            ),
        ),
        migrations.AlterField(
            model_name='reader',
            name='resource',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='readers',
                to='qrcode.qrcodeconnector',
            ),
        ),
        migrations.RunPython(set_default_campaign, remove_campaign),
        migrations.RemoveField(
            model_name='certificate',
            name='resource',
        ),
        migrations.RemoveField(
            model_name='reader',
            name='resource',
        ),
        migrations.RemoveField(
            model_name='qrcodeconnector',
            name='key',
        ),
        migrations.AlterField(
            model_name='certificate',
            name='campaign',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, related_name='certificates', to='qrcode.campaign'
            ),
        ),
        migrations.AlterField(
            model_name='reader',
            name='campaign',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, related_name='readers', to='qrcode.campaign'
            ),
        ),
    ]
