# Generated by Django 3.2.18 on 2023-11-02 09:29

import uuid

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models

import passerelle.apps.qrcode.models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('base', '0030_resourcelog_base_resour_appname_298cbc_idx'),
    ]

    operations = [
        migrations.CreateModel(
            name='QRCodeConnector',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'key',
                    models.CharField(
                        default=passerelle.apps.qrcode.models.generate_key,
                        max_length=64,
                        validators=[
                            django.core.validators.RegexValidator(
                                '[a-z|0-9]{64}', 'Key should be a 32 bytes hexadecimal string'
                            )
                        ],
                        verbose_name='Private Key',
                    ),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'QR Code',
            },
        ),
        migrations.CreateModel(
            name='Certificate',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True, verbose_name='UUID')),
                ('validity_start', models.DateTimeField(verbose_name='Validity Start Date')),
                ('validity_end', models.DateTimeField(verbose_name='Validity End Date')),
                ('data', models.JSONField(null=True, verbose_name='Certificate Data')),
                (
                    'resource',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='certificates',
                        to='qrcode.qrcodeconnector',
                    ),
                ),
            ],
        ),
    ]
