from django.db import migrations


def update_auth_type(apps, schema_editor):
    model = apps.get_model('proxy', 'Resource')
    model.objects.filter(auth_type='oauth2').update(auth_type='oauth2_client_credentials')


class Migration(migrations.Migration):
    dependencies = [
        ('proxy', '0004_alter_resource_auth_type'),
    ]

    operations = [
        migrations.RunPython(update_auth_type),
    ]
