# Generated by Django 1.11.17 on 2019-01-21 14:14

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('base', '0010_loggingparameters_trace_emails'),
    ]

    operations = [
        migrations.CreateModel(
            name='Call',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('callee', models.CharField(max_length=64)),
                ('caller', models.CharField(max_length=64)),
                ('start_timestamp', models.DateTimeField(auto_now_add=True)),
                ('end_timestamp', models.DateTimeField(default=None, null=True)),
                ('details', models.JSONField(default=dict)),
            ],
            options={
                'ordering': ['-start_timestamp'],
                'verbose_name': 'Phone Call',
            },
        ),
        migrations.CreateModel(
            name='PhoneCalls',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('description', models.TextField(verbose_name='Description')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                (
                    'max_call_duration',
                    models.PositiveIntegerField(
                        default=120,
                        help_text='Each hour, too long calls are closed.',
                        verbose_name='Maximum duration of a call, in minutes.',
                    ),
                ),
                (
                    'data_retention_period',
                    models.PositiveIntegerField(
                        default=60,
                        help_text='Each day, old calls are removed.',
                        verbose_name='Data retention period, in days.',
                    ),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Phone Calls',
            },
        ),
        migrations.AddField(
            model_name='call',
            name='resource',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='phonecalls.PhoneCalls'),
        ),
    ]
