# Generated by Django 4.2.15 on 2025-03-05 11:39

from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ('opendatasoft', '0004_query_limit'),
    ]

    operations = [
        migrations.AddField(
            model_name='query',
            name='dist',
            field=models.CharField(
                blank=True,
                default='50.0m',
                help_text='Only include results inside lat/lon/dist circle. Example: 2km',
                max_length=128,
                verbose_name='Distance (API v2)',
            ),
        ),
        migrations.AddField(
            model_name='query',
            name='exclude',
            field=models.TextField(
                blank=True,
                help_text='Facet filter used to exclude a facet value from the result set',
                verbose_name='Exclude (API v2)',
            ),
        ),
        migrations.AddField(
            model_name='query',
            name='geo_point',
            field=models.CharField(
                blank=True,
                help_text='Geographic point field in the dataset',
                max_length=256,
                verbose_name='Geo point 2D (API v2)',
            ),
        ),
        migrations.AddField(
            model_name='query',
            name='group_by',
            field=models.TextField(
                blank=True,
                help_text='Expression to defines a grouping function for an aggregation',
                verbose_name='Group by (API v2)',
            ),
        ),
        migrations.AddField(
            model_name='query',
            name='lang',
            field=models.CharField(
                blank=True,
                help_text='If specified, override the default language, which is "fr"',
                max_length=256,
                verbose_name='Lang (API v2)',
            ),
        ),
        migrations.AddField(
            model_name='query',
            name='lat',
            field=models.FloatField(
                blank=True,
                help_text='Geographic limitation and priority',
                null=True,
                verbose_name='Latitude (API v2)',
            ),
        ),
        migrations.AddField(
            model_name='query',
            name='lon',
            field=models.FloatField(
                blank=True,
                help_text='Geographic limitation and priority',
                null=True,
                verbose_name='Longitude (API v2)',
            ),
        ),
        migrations.AddField(
            model_name='query',
            name='order_by',
            field=models.CharField(
                blank=True,
                help_text='Comma-separated list of field names or aggregations to sort on, followed by an order (asc or desc)',
                max_length=256,
                verbose_name='Order by (API v2)',
            ),
        ),
        migrations.AddField(
            model_name='query',
            name='output',
            field=models.CharField(
                choices=[
                    ('json', 'Format outputs as JSON (default)'),
                    ('geojson', 'Format outputs as GeoJSON'),
                ],
                default='json',
                max_length=10,
                verbose_name='Output format (API v2)',
            ),
        ),
        migrations.AddField(
            model_name='query',
            name='q_filter',
            field=models.CharField(
                choices=[
                    ('search', 'Case insensitive fuzzy and prefix search (search)'),
                    (
                        'suggest',
                        'Case insensitive search beginning with the searched string (suggest)',
                    ),
                    (
                        'startswith',
                        'Case sensitive search, on the whole string, without splitting it by spaces and forming terms before (startswith)',
                    ),
                ],
                default='search',
                max_length=10,
                verbose_name='Full text searches function to use (API v2)',
            ),
        ),
        migrations.AddField(
            model_name='query',
            name='refine',
            field=models.TextField(
                blank=True,
                help_text='Facet filter used to limit the result set',
                verbose_name='Refine (API v2)',
            ),
        ),
        migrations.AddField(
            model_name='query',
            name='select',
            field=models.TextField(
                blank=True,
                help_text='Select expression to add, remove or change the fields to return',
                verbose_name='Select (API v2)',
            ),
        ),
        migrations.AddField(
            model_name='query',
            name='timezone',
            field=models.CharField(
                blank=True,
                help_text='Set the timezone for datetime fields',
                max_length=256,
                verbose_name='Timezone (API v2)',
            ),
        ),
        migrations.AddField(
            model_name='query',
            name='where',
            field=models.TextField(
                blank=True,
                help_text='Filter expression including logical operations and functions',
                verbose_name='Where (API v2)',
            ),
        ),
        migrations.AlterField(
            model_name='opendatasoft',
            name='service_url',
            field=models.CharField(
                help_text='URL without ending "api/..."',
                max_length=256,
                verbose_name='Site URL',
            ),
        ),
        migrations.AlterField(
            model_name='query',
            name='dataset',
            field=models.CharField(help_text='Dataset to query', max_length=128, verbose_name='Dataset'),
        ),
        migrations.AlterField(
            model_name='query',
            name='filter_expression',
            field=models.TextField(
                blank=True,
                help_text='Specify refine and exclude facet expressions separated lines',
                verbose_name='Filter (API v1)',
            ),
        ),
        migrations.AlterField(
            model_name='query',
            name='sort',
            field=models.CharField(
                blank=True,
                help_text='Sorts results by the specified field. A minus sign - may be used to perform an ascending sort.',
                max_length=256,
                verbose_name='Sort field (API v1)',
            ),
        ),
    ]
