# Generated by Django 3.2.18 on 2024-03-11 09:20

from django.db import migrations, models

import passerelle.utils.templates


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('base', '0030_resourcelog_base_resour_appname_298cbc_idx'),
    ]

    operations = [
        migrations.CreateModel(
            name='Mgdis',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'basic_auth_username',
                    models.CharField(
                        blank=True, max_length=128, verbose_name='Basic authentication username'
                    ),
                ),
                (
                    'basic_auth_password',
                    models.CharField(
                        blank=True, max_length=128, verbose_name='Basic authentication password'
                    ),
                ),
                (
                    'client_certificate',
                    models.FileField(
                        blank=True, null=True, upload_to='', verbose_name='TLS client certificate'
                    ),
                ),
                (
                    'trusted_certificate_authorities',
                    models.FileField(blank=True, null=True, upload_to='', verbose_name='TLS trusted CAs'),
                ),
                (
                    'verify_cert',
                    models.BooleanField(blank=True, default=True, verbose_name='TLS verify certificates'),
                ),
                (
                    'http_proxy',
                    models.CharField(blank=True, max_length=128, verbose_name='HTTP and HTTPS proxy'),
                ),
                (
                    'base_url',
                    models.URLField(
                        help_text='Example: https://test.mgcloud.fr/', verbose_name='Webservice Base URL'
                    ),
                ),
                ('tenant_id', models.CharField(max_length=128, verbose_name='Tenant identifier')),
                (
                    'demand_name_template',
                    models.CharField(
                        default='{{ text }}',
                        max_length=128,
                        validators=[passerelle.utils.templates.validate_template],
                        verbose_name='Demand name template',
                    ),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'MGDIS',
            },
        ),
    ]
