# Generated by Django 2.2.19 on 2021-05-17 11:43

from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('base', '0029_auto_20210202_1627'),
    ]

    operations = [
        migrations.CreateModel(
            name='Resource',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'fc_platform_slug',
                    models.CharField(
                        choices=[('test', 'Testing'), ('prod', 'Production')],
                        max_length=4,
                        verbose_name='FranceConnect platform',
                    ),
                ),
                ('fc_client_id', models.CharField(max_length=64, verbose_name='FranceConnect client_id')),
                (
                    'fc_client_secret',
                    models.CharField(max_length=64, verbose_name='FranceConnect client_secret'),
                ),
                (
                    'fc_scopes',
                    models.TextField(default='identite_pivot', verbose_name='FranceConnect scopes'),
                ),
                (
                    'text_template',
                    models.TextField(
                        default=(
                            '''{{ fc.given_name }} {{ fc.family_name }} '''
                            '''{% if fc.gender == 'male' %}né{% else %}née{% endif %} le {{ fc.birthdate|date:"j F Y" }}'''
                        ),
                        verbose_name='Text template',
                    ),
                ),
                (
                    'dgfip_username',
                    models.CharField(blank=True, max_length=64, null=True, verbose_name='DGFIP API Username'),
                ),
                (
                    'dgfip_password',
                    models.CharField(blank=True, max_length=64, null=True, verbose_name='DGFIP API Password'),
                ),
                (
                    'dgfip_scopes',
                    models.TextField(blank=True, null=True, verbose_name='DGFIP API Scopes'),
                ),
                (
                    'dgfip_id_teleservice',
                    models.TextField(blank=True, null=True, verbose_name='DGFIP API ID_Teleservice'),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={'verbose_name': 'Data sources through FranceConnect'},
        ),
    ]
