# Generated by Django 1.11.20 on 2020-03-10 20:17

import django.db.models.deletion
from django.db import migrations, models

import passerelle.apps.arcgis.models
import passerelle.utils.templates


class Migration(migrations.Migration):
    dependencies = [
        ('arcgis', '0004_remove_arcgis_log_level'),
    ]

    operations = [
        migrations.CreateModel(
            name='Query',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('name', models.CharField(max_length=128, verbose_name='Name')),
                ('slug', models.SlugField(max_length=128, verbose_name='Slug')),
                ('description', models.TextField(blank=True, verbose_name='Description')),
                ('folder', models.CharField(blank=True, max_length=64, verbose_name='ArcGis Folder')),
                ('service', models.CharField(max_length=64, verbose_name='ArcGis Service')),
                ('layer', models.CharField(blank=True, max_length=8, verbose_name='ArcGis Layer')),
                (
                    'where',
                    models.TextField(
                        blank=True,
                        help_text=(
                            '<div>Use syntax <tt>{name}</tt> to introduce a string parameter and '
                            '<tt>{name:d}</tt> for a decimal parameter. Use syntax <tt>{name:l}</tt> '
                            'for a parameter that should be interpreted a a list of strings '
                            '(comma-separated). ex.:</div>'
                            '<tt>adress LIKE (\'%\' || UPPER({adress}) || \'%\')</tt><br>'
                            '<tt>population < {population:d}</tt><br>'
                            '<tt>ID IN {ids:l}</tt> (with ids being "11,13,17")'
                        ),
                        validators=[passerelle.apps.arcgis.models.validate_where],
                        verbose_name='ArcGis Where Clause',
                    ),
                ),
                (
                    'id_template',
                    models.TextField(
                        blank=True,
                        help_text="Use Django's template syntax. Attributes can be accessed through {{ attributes.name }}",
                        validators=[passerelle.utils.templates.validate_template],
                        verbose_name='Id template',
                    ),
                ),
                (
                    'text_template',
                    models.TextField(
                        blank=True,
                        help_text="Use Django's template syntax. Attributes can be accessed through {{ attributes.name }}",
                        validators=[passerelle.utils.templates.validate_template],
                        verbose_name='Text template',
                    ),
                ),
                (
                    'resource',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='queries',
                        to='arcgis.ArcGIS',
                        verbose_name='Resource',
                    ),
                ),
            ],
            options={'ordering': ['name'], 'verbose_name': 'Query'},
        ),
        migrations.AlterUniqueTogether(
            name='query',
            unique_together={('resource', 'name'), ('resource', 'slug')},
        ),
    ]
