# Generated by Django 2.2.28 on 2022-06-16 08:31

import uuid

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('base', '0029_auto_20210202_1627'),
    ]

    operations = [
        migrations.CreateModel(
            name='Resource',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'basic_auth_username',
                    models.CharField(
                        blank=True, max_length=128, verbose_name='Basic authentication username'
                    ),
                ),
                (
                    'basic_auth_password',
                    models.CharField(
                        blank=True, max_length=128, verbose_name='Basic authentication password'
                    ),
                ),
                (
                    'client_certificate',
                    models.FileField(
                        blank=True, null=True, upload_to='', verbose_name='TLS client certificate'
                    ),
                ),
                (
                    'trusted_certificate_authorities',
                    models.FileField(blank=True, null=True, upload_to='', verbose_name='TLS trusted CAs'),
                ),
                (
                    'verify_cert',
                    models.BooleanField(blank=True, default=True, verbose_name='TLS verify certificates'),
                ),
                (
                    'http_proxy',
                    models.CharField(blank=True, max_length=128, verbose_name='HTTP and HTTPS proxy'),
                ),
                (
                    'bbb_url',
                    models.URLField(
                        help_text='Base URL of Big Blue Button (use "bbb-conf --secret" to get it)',
                        max_length=400,
                        verbose_name='BBB URL',
                    ),
                ),
                (
                    'shared_secret',
                    models.CharField(
                        help_text='Use "bbb-conf --secret" to get it.',
                        verbose_name='Shared secret',
                        max_length=128,
                    ),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Big Blue Button',
            },
        ),
        migrations.CreateModel(
            name='Meeting',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('guid', models.UUIDField(default=uuid.uuid4, unique=True, verbose_name='UUID')),
                ('name', models.TextField(verbose_name='Name')),
                ('idempotent_id', models.TextField(unique=True, verbose_name='Idempotent ID')),
                ('running', models.BooleanField(default=False, verbose_name='Is running?')),
                ('last_time_running', models.DateTimeField(null=True, verbose_name='Last time running')),
                (
                    'create_parameters',
                    models.JSONField(null=True, verbose_name='Create parameters'),
                ),
                ('user_full_name', models.TextField(null=True, verbose_name='User full name')),
                ('agent_full_name', models.TextField(null=True, verbose_name='Agent full name')),
                (
                    'join_user_parameters',
                    models.JSONField(null=True, verbose_name='Join user parameters'),
                ),
                (
                    'join_agent_parameters',
                    models.JSONField(null=True, verbose_name='Join agent parameters'),
                ),
                (
                    'metadata',
                    models.JSONField(null=True, verbose_name='Metadata'),
                ),
                (
                    'resource',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='meetings',
                        to='bbb.Resource',
                        verbose_name='Resource',
                    ),
                ),
            ],
        ),
    ]
