# Generated by Django 3.2.19 on 2024-07-29 14:59

from django.db import migrations, models


def set_auth_type(apps, *args):
    # set auth_type to basic_auth when needed
    # not efficient but don't need to be
    proxies = apps.get_model('proxy', 'Resource')
    for proxy in proxies.objects.all():
        if proxy.basic_auth_username and proxy.basic_auth_password:
            proxy.auth_type = 'basic_auth'
            proxy.save()


class Migration(migrations.Migration):
    dependencies = [
        ('proxy', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='resource',
            name='amazon_cognito_client_id',
            field=models.CharField(blank=True, max_length=128, verbose_name='Amazon cognito ClientId'),
        ),
        migrations.AddField(
            model_name='resource',
            name='auth_type',
            field=models.CharField(
                blank=True,
                choices=[
                    ('basic_auth', 'Basic Authentication'),
                    ('oauth2', 'OAuth 2'),
                    ('amazon_cognito_access_token', 'Amazon Cognito (AccessToken)'),
                    ('amazon_cognito_id_token', 'Amazon Cognito (IdToken)'),
                ],
                max_length=32,
                verbose_name='Authentication',
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='resource',
            name='oauth2_password',
            field=models.CharField(blank=True, max_length=128, verbose_name='Oauth2 password'),
        ),
        migrations.AddField(
            model_name='resource',
            name='oauth2_scopes',
            field=models.CharField(blank=True, max_length=128, verbose_name='Oauth2 scopes'),
        ),
        migrations.AddField(
            model_name='resource',
            name='oauth2_token_url',
            field=models.CharField(blank=True, max_length=256, verbose_name='Oauth2 token url'),
        ),
        migrations.AddField(
            model_name='resource',
            name='oauth2_username',
            field=models.CharField(blank=True, max_length=128, verbose_name='Oauth2 username'),
        ),
        migrations.AlterField(
            model_name='resource',
            name='http_timeout',
            field=models.PositiveIntegerField(
                default=5, verbose_name='Timeout on upstream, in seconds. Use 0 for system default (25s)'
            ),
        ),
        migrations.RunPython(set_auth_type),
    ]
