# Copyright (C) 2025 Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from . import schemas

NURSERY_SCHEMA = {
    'title': 'Nursery',
    'description': 'Crèche',
    'type': 'object',
    'required': ['idActivity', 'idUnit', 'idPlace'],
    'properties': {
        'idActivity': {
            'description': 'Identifiant d\'activité',
            'type': 'string',
        },
        'idUnit': {
            'description': 'Identifiant unité',
            'type': 'string',
        },
        'idPlace': {
            'description': 'Identifiant lieu',
            'type': 'string',
        },
    },
}

NURSERY_DEMAND_SCHEMA = {
    'title': 'Nursery demand',
    'description': 'Crée une demande de place en crèche',
    'type': 'object',
    'required': ['family_id', 'start_date'],
    'properties': {
        'family_id': {
            'description': 'Numéro DUI',
            'type': 'string',
        },
        'family_indicators': {
            'oneOf': [
                {
                    'type': 'array',
                    'items': schemas.INDICATOR_SCHEMA,
                }
            ],
            'description': 'Liste des indicateurs à positionner sur la famille',
        },
        'child_id': {
            'description': 'Identifiant de l\'enfant',
            'type': 'string',
        },
        'child_first_name': {
            'description': 'Prénom de l\'enfant',
            'type': 'string',
        },
        'child_last_name': {
            'description': 'Nom de l\'enfant',
            'type': 'string',
        },
        'child_gender': {
            'description': 'Sexe de l\'enfant',
            'type': 'string',
        },
        'child_birthdate': {
            'description': 'Date de naissance ou date de naissance prévisionnelle de l\'enfant',
            'type': 'string',
        },
        'child_indicators': {
            'oneOf': [
                {
                    'type': 'array',
                    'items': schemas.INDICATOR_SCHEMA,
                }
            ],
            'description': 'Liste des indicateurs à positionner sur l\'enfant',
        },
        'demand_indicators': {
            'oneOf': [
                {
                    'type': 'array',
                    'items': schemas.INDICATOR_SCHEMA,
                }
            ],
            'description': 'Liste des indicateurs à positionner sur la demande',
        },
        'start_date': {
            'description': 'Date d\'entrée en structure souhaitée',
            'type': 'string',
            'pattern': '^[0-9]{4}-[0-9]{2}-[0-9]{2}$',
        },
        'number_of_days': {
            'description': 'Nombre de jours par semaine',
            'type': 'string',
            'pattern': '^[0-7]{1}$',
        },
        'start_hour_Mon': {
            'description': 'Heure de début le lundi',
            'type': 'string',
            'pattern': '^([0-9]{2}:[0-9]{2}){0,1}$',
        },
        'end_hour_Mon': {
            'description': 'Heure de fin le lundi',
            'type': 'string',
            'pattern': '^([0-9]{2}:[0-9]{2}){0,1}$',
        },
        'start_hour_Tue': {
            'description': 'Heure de début le mardi',
            'type': 'string',
            'pattern': '^([0-9]{2}:[0-9]{2}){0,1}$',
        },
        'end_hour_Tue': {
            'description': 'Heure de fin le mardi',
            'type': 'string',
            'pattern': '^([0-9]{2}:[0-9]{2}){0,1}$',
        },
        'start_hour_Wed': {
            'description': 'Heure de début le mercedi',
            'type': 'string',
            'pattern': '^([0-9]{2}:[0-9]{2}){0,1}$',
        },
        'end_hour_Wed': {
            'description': 'Heure de fin le mercredi',
            'type': 'string',
            'pattern': '^([0-9]{2}:[0-9]{2}){0,1}$',
        },
        'start_hour_Thu': {
            'description': 'Heure de début le jeudi',
            'type': 'string',
            'pattern': '^([0-9]{2}:[0-9]{2}){0,1}$',
        },
        'end_hour_Thu': {
            'description': 'Heure de fin le jeudi',
            'type': 'string',
            'pattern': '^([0-9]{2}:[0-9]{2}){0,1}$',
        },
        'start_hour_Fri': {
            'description': 'Heure de début le vendredi',
            'type': 'string',
            'pattern': '^([0-9]{2}:[0-9]{2}){0,1}$',
        },
        'end_hour_Fri': {
            'description': 'Heure de fin le vendredi',
            'type': 'string',
            'pattern': '^([0-9]{2}:[0-9]{2}){0,1}$',
        },
        'start_hour_Sat': {
            'description': 'Heure de début le samedi',
            'type': 'string',
            'pattern': '^([0-9]{2}:[0-9]{2}){0,1}$',
        },
        'end_hour_Sat': {
            'description': 'Heure de fin le samedi',
            'type': 'string',
            'pattern': '^([0-9]{2}:[0-9]{2}){0,1}$',
        },
        'start_hour_Sun': {
            'description': 'Heure de début le dimanche',
            'type': 'string',
            'pattern': '^([0-9]{2}:[0-9]{2}){0,1}$',
        },
        'end_hour_Sun': {
            'description': 'Heure de fin le dimanche',
            'type': 'string',
            'pattern': '^([0-9]{2}:[0-9]{2}){0,1}$',
        },
        'comment': {
            'description': 'Commentaire à propos du besoin d\'accueil',
            'type': 'string',
        },
        'accept_other_nurseries': {
            'description': 'Accepter d\'autres crèches',
            'oneOf': schemas.BOOLEAN_TYPES,
        },
        'nursery1': {
            'description': 'Premier choix de crèche',
            'oneOf': [NURSERY_SCHEMA],
        },
        'nursery2': {
            'description': 'Deuxième choix de crèche',
            'oneOf': [NURSERY_SCHEMA],
        },
        'nursery3': {
            'description': 'Troisième choix de crèche',
            'oneOf': [NURSERY_SCHEMA],
        },
    },
    'unflatten': True,
    'additionalProperties': False,
}

CONFIRM_BIRTH_SCHEMA = {
    'title': 'Confirm birth',
    'description': 'Paramètre pour le WS maélis confirmChildBirth',
    'type': 'object',
    'required': ['numPerson'],
    'properties': {
        'numPerson': {
            'description': "Numéro de l'enfant",
            'type': 'string',
        },
        'firstname': {
            'description': 'Prénom',
            'type': 'string',
        },
        'lastname': {
            'description': 'Nom',
            'type': 'string',
        },
        'sexe': {
            'description': 'Sexe (depuis référentiel)',
            'type': 'string',
            'pattern': '.+',
        },
        'birth': schemas.BIRTH_SCHEMA,
    },
}
