# Generated by Django 4.2.15 on 2025-05-15 13:36

import uuid

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0035_update_trace_email'),
    ]

    operations = [
        migrations.CreateModel(
            name='Alert',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'uuid',
                    models.UUIDField(default=uuid.uuid4, unique=True, verbose_name='UUID'),
                ),
                (
                    'status_update_trigger_url',
                    models.CharField(blank=True, null=True, verbose_name='status-update-trigger-url'),
                ),
            ],
        ),
        migrations.CreateModel(
            name='CiteosConnector',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'oauth2_token_url',
                    models.CharField(blank=True, max_length=256, verbose_name='Oauth2 token url'),
                ),
                (
                    'oauth2_username',
                    models.CharField(blank=True, max_length=128, verbose_name='Oauth2 username'),
                ),
                (
                    'oauth2_password',
                    models.CharField(blank=True, max_length=128, verbose_name='Oauth2 password'),
                ),
                (
                    'oauth2_scopes',
                    models.CharField(blank=True, max_length=128, verbose_name='Oauth2 scopes'),
                ),
                ('add_alert_url', models.URLField(verbose_name='Add Alert Endpoint')),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='+',
                        related_query_name='+',
                        to='base.apiuser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'CITEOS',
            },
        ),
        migrations.CreateModel(
            name='Document',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'uuid',
                    models.UUIDField(default=uuid.uuid4, unique=True, verbose_name='UUID'),
                ),
                ('content', models.BinaryField(verbose_name='content')),
                (
                    'content_type',
                    models.CharField(blank=True, null=True, verbose_name='content-type'),
                ),
                (
                    'alert',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='documents',
                        to='citeos.alert',
                    ),
                ),
                (
                    'resource',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='documents',
                        to='citeos.citeosconnector',
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name='alert',
            name='resource',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='alerts',
                to='citeos.citeosconnector',
            ),
        ),
    ]
