#!/usr/bin/python3

import argparse

import utils

PERSON_ID = '263781'  # BART SIMPSON


def check(args):
    utils.configure_logging(args.verbose)
    client = utils.get_client(args.env, 'Ape')

    result = client.service.readApeBookList(
        request={
            'numPerson': args.person,
        },
    )
    if args.verbose > 1:
        print(result)

    for book in result or []:
        print('* idApeBook %s: apeBookState %s' % (book['idApeBook'], book['apeBookState']['code']))

    return result


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--verbose', '-v', type=int, default=2, help='display errors')
    parser.add_argument('--env', '-e', default='integ', help='dev, test, integ, prod')
    parser.add_argument('--person', '-P', default=PERSON_ID, help='person id')
    args = parser.parse_args()
    check(args)
