# Generated by Django 1.11.18 on 2021-02-07 22:48

from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('base', '0029_auto_20210202_1627'),
    ]

    operations = [
        migrations.CreateModel(
            name='AddressCacheModel',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('api_id', models.CharField(max_length=32, unique=True)),
                ('data', models.JSONField()),
                ('timestamp', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Photon',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'service_url',
                    models.CharField(
                        default='https://photon.komoot.io/',
                        help_text='Base Adresse Web Service URL',
                        max_length=128,
                        verbose_name='Service URL',
                    ),
                ),
                (
                    'latitude',
                    models.FloatField(
                        blank=True,
                        help_text='Geographic priority for /addresses/ endpoint.',
                        null=True,
                        verbose_name='Latitude',
                    ),
                ),
                (
                    'longitude',
                    models.FloatField(
                        blank=True,
                        help_text='Geographic priority for /addresses/ endpoint.',
                        null=True,
                        verbose_name='Longitude',
                    ),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True, related_name='+', related_query_name='+', to='base.ApiUser'
                    ),
                ),
            ],
            options={
                'verbose_name': 'Photon',
            },
        ),
    ]
