# Generated by Django 2.2.26 on 2023-01-08 12:18

from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('base', '0030_resourcelog_base_resour_appname_298cbc_idx'),
    ]

    operations = [
        migrations.CreateModel(
            name='Resource',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'basic_auth_username',
                    models.CharField(
                        blank=True, max_length=128, verbose_name='Basic authentication username'
                    ),
                ),
                (
                    'basic_auth_password',
                    models.CharField(
                        blank=True, max_length=128, verbose_name='Basic authentication password'
                    ),
                ),
                (
                    'client_certificate',
                    models.FileField(
                        blank=True, null=True, upload_to='', verbose_name='TLS client certificate'
                    ),
                ),
                (
                    'trusted_certificate_authorities',
                    models.FileField(blank=True, null=True, upload_to='', verbose_name='TLS trusted CAs'),
                ),
                (
                    'verify_cert',
                    models.BooleanField(blank=True, default=True, verbose_name='TLS verify certificates'),
                ),
                (
                    'http_proxy',
                    models.CharField(blank=True, max_length=128, verbose_name='HTTP and HTTPS proxy'),
                ),
                ('upstream_base_url', models.URLField(verbose_name='Upstream Service Base URL')),
                (
                    'http_timeout',
                    models.PositiveIntegerField(
                        default=5,
                        verbose_name='Timeout on upstream, in seconds. Use 0 for system default (25s)',
                    ),
                ),
                (
                    'forced_headers',
                    models.TextField(
                        blank=True,
                        help_text='Headers to always add (one per line, format "Header-Name: value")',
                        verbose_name='Headers',
                    ),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='_resource_users_+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Proxy',
            },
        ),
    ]
