# Generated by Django 1.11.20 on 2019-10-24 08:59

import django.db.models.deletion
from django.db import migrations, models

import passerelle.utils.sftp


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('base', '0015_auto_20190921_0347'),
    ]

    operations = [
        migrations.CreateModel(
            name='Demand',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=32, unique=True)),
                (
                    'status',
                    models.CharField(
                        choices=[
                            ('pending', 'pending'),
                            ('pushed', 'pushed'),
                            ('error', 'error'),
                            ('closed', 'closed'),
                            ('rejected', 'rejected'),
                            ('accepted', 'accepted'),
                            ('information needed', 'information needed'),
                            ('in progress', 'in progress'),
                            ('invalid', 'invalid'),
                            ('imported', 'imported'),
                        ],
                        default='pending',
                        max_length=32,
                        null=True,
                    ),
                ),
                ('step', models.IntegerField(default=0)),
                ('data', models.JSONField(default=dict)),
            ],
            options={
                'verbose_name': 'MDEL compatible DDPACS request',
            },
        ),
        migrations.CreateModel(
            name='Resource',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('description', models.TextField(verbose_name='Description')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                (
                    'outgoing_sftp',
                    passerelle.utils.sftp.SFTPField(blank=True, default=None, verbose_name='Outcoming SFTP'),
                ),
                (
                    'incoming_sftp',
                    passerelle.utils.sftp.SFTPField(blank=True, default=None, verbose_name='Incoming SFTP'),
                ),
                ('recipient_siret', models.CharField(max_length=128, verbose_name='SIRET')),
                ('recipient_service', models.CharField(max_length=128, verbose_name='Service')),
                ('recipient_guichet', models.CharField(max_length=128, verbose_name='Guichet')),
                ('code_insee', models.CharField(max_length=6, verbose_name='INSEE Code')),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='_resource_users_+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'MDEL compatible DDPACS request builder',
            },
        ),
        migrations.AddField(
            model_name='demand',
            name='resource',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mdel_ddpacs.Resource'),
        ),
    ]
