# Generated by Django 2.2.26 on 2022-09-21 08:39

import django.contrib.postgres.fields
import django.core.validators
from django.db import migrations, models

import passerelle.sms.models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('base', '0029_auto_20210202_1627'),
    ]

    operations = [
        migrations.CreateModel(
            name='SMSFactorSMSGateway',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'default_country_code',
                    models.CharField(
                        default='33',
                        max_length=3,
                        validators=[
                            django.core.validators.RegexValidator(
                                '^[0-9]*$', 'The country must only contain numbers'
                            )
                        ],
                        verbose_name='Default country code',
                    ),
                ),
                (
                    'default_trunk_prefix',
                    models.CharField(
                        default='0',
                        max_length=2,
                        validators=[
                            django.core.validators.RegexValidator(
                                '^[0-9]*$', 'The trunk prefix must only contain numbers'
                            )
                        ],
                        verbose_name='Default trunk prefix',
                    ),
                ),
                (
                    'max_message_length',
                    models.IntegerField(
                        default=2000,
                        help_text='Messages over this limit will be truncated.',
                        verbose_name='Maximum message length',
                    ),
                ),
                (
                    'authorized',
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(
                            choices=[
                                ('fr-metro', 'France mainland (+33 [67])'),
                                ('fr-domtom', 'France DOM/TOM (+262, etc.)'),
                                ('be', 'Belgian (+32 4[5-9]) '),
                                ('all', 'All'),
                            ],
                            max_length=32,
                            null=True,
                        ),
                        default=passerelle.sms.models.authorized_default,
                        size=None,
                        verbose_name='Authorized Countries',
                    ),
                ),
                ('auth_token', models.CharField(max_length=255, verbose_name='Auth Token')),
                (
                    'credit_threshold_alert',
                    models.PositiveIntegerField(default=500, verbose_name='Credit alert threshold'),
                ),
                (
                    'credit_left',
                    models.PositiveIntegerField(default=0, editable=False, verbose_name='Credit left'),
                ),
                (
                    'alert_emails',
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.EmailField(blank=True, max_length=254),
                        blank=True,
                        null=True,
                        size=None,
                        verbose_name='Email addresses list to send credit alerts to, separated by comma',
                    ),
                ),
                ('credit_alert_timestamp', models.DateTimeField(editable=False, null=True)),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='_smsfactorsmsgateway_users_+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'SMS Factor',
                'db_table': 'sms_factor',
            },
        ),
    ]
