from django.contrib import admin

from .models import Link


@admin.register(Link)
class LinkAdmin(admin.ModelAdmin):
    data_hierarchy = 'created'
    search_fields = ['display_name', 'file_number', 'dob']
    list_display = ['id', 'created', 'resource', 'name_id', 'file_number']
