# Generated by Django 1.11.12 on 2019-02-20 10:38

from django.db import migrations, models

import passerelle.apps.cartads_cs.models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('base', '0012_job'),
    ]

    operations = [
        migrations.CreateModel(
            name='CartaDSCS',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('description', models.TextField(verbose_name='Description')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                (
                    'wsdl_base_url',
                    models.URLField(
                        help_text='ex: https://example.net/adscs/webservices/', verbose_name='WSDL Base URL'
                    ),
                ),
                ('username', models.CharField(max_length=64, verbose_name='Username')),
                ('password', models.CharField(max_length=64, verbose_name='Password')),
                ('iv', models.CharField(max_length=16, verbose_name='Initialisation Vector')),
                ('secret_key', models.CharField(max_length=16, verbose_name='Secret Key')),
                ('ftp_server', models.CharField(max_length=128, verbose_name='FTP Server')),
                ('ftp_username', models.CharField(max_length=64, verbose_name='FTP Username')),
                ('ftp_password', models.CharField(max_length=64, verbose_name='FTP Password')),
                ('ftp_client_name', models.CharField(max_length=64, verbose_name='FTP Client Name')),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='_cartadscs_users_+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Cart@DS CS',
            },
        ),
        migrations.CreateModel(
            name='CartaDSDossier',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('email', models.CharField(max_length=256)),
                ('tracking_code', models.CharField(max_length=20)),
                ('commune_id', models.CharField(max_length=20)),
                ('type_dossier_id', models.CharField(max_length=20)),
                ('objet_demande_id', models.CharField(max_length=20, null=True)),
                ('zip_ready', models.BooleanField(default=False)),
                ('zip_sent', models.BooleanField(default=False)),
                ('zip_ack_response', models.CharField(max_length=20, null=True)),
                ('notification_url', models.URLField(null=True)),
                ('notification_message', models.TextField(null=True)),
                ('cartads_id_dossier', models.CharField(max_length=50, null=True)),
                ('cartads_numero_dossier', models.CharField(max_length=50, null=True)),
                ('last_update_datetime', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='CartaDSFile',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('tracking_code', models.CharField(max_length=20)),
                ('id_piece', models.CharField(max_length=20)),
                (
                    'uploaded_file',
                    models.FileField(upload_to=passerelle.apps.cartads_cs.models.cartads_file_location),
                ),
                ('last_update_datetime', models.DateTimeField(auto_now=True)),
            ],
        ),
    ]
