# Generated by Django 2.2.24 on 2022-03-17 13:55

from django.db import migrations


def migrate_job(apps, schema_editor):
    '''Replace wcs_form_api_url by uuid in child models.'''
    Job = apps.get_model('base', 'Job')
    WcsRequest = apps.get_model('toulouse_smart', 'WcsRequest')
    jobs = Job.objects.filter(
        resource_type__app_label='toulouse_smart',
        resource_type__model='toulousesmartresource',
        method_name='create_intervention_job',
    )

    for job in jobs:
        if not job.parameters or 'pk' not in job.parameters:
            continue
        try:
            wcs_request = WcsRequest.objects.get(wcs_form_api_url=job.parameters['pk'])
        except WcsRequest.DoesNotExist:
            continue
        job.parameters['pk'] = str(wcs_request.uuid)
        job.save(update_fields=['parameters'])


class Migration(migrations.Migration):
    dependencies = [
        ('toulouse_smart', '0011_rename_fk'),
        ('base', '0029_auto_20210202_1627'),
    ]

    operations = [
        migrations.RunPython(migrate_job, migrations.RunPython.noop),
    ]
